@extends('layouts.app')

@php
    $heading = $page->heading ?? __('Classifieds');
    $description = $page->content ?? __('Classifieds');
    $libraries = 'places,marker';
    $breadcrumbs = ['name' => 'classifieds'];
@endphp
@push('seo')
    {!! seo($page ?? null) !!}
@endpush

@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries={{ $libraries }}" async defer></script>
    {{-- The google-maps.js file is now imported in esp_theme.js via ES modules --}}
@endpush

@section('content')
    <section class="pt-8 pb-0 lg:py-8">
        <livewire:frontend.classified.classified-list :page="$page" :breadcrumbs="$breadcrumbs" />
    </section>
@endsection
