@props(['article', 'target' => '_self'])
<div class="group hover:shadow-10xl transition-all duration-500 ease-in-out bg-white border border-solid border-gray-1200 rounded-2xl p-6 shadow-7xl flex flex-col">
    <a href="{{ route('journal.show', ['slug' => $article->slug]) }}" target="{{ $target }}">
        @if ($article->getFirstMediaUrl('featured_image'))
            <div class="flex items-center flex-col border border-solid border-gray-1200 rounded-xl">
                <img src="{{ $article->getFirstMediaUrl('featured_image', 'thumb') }}"
                    alt="{{ str()->limit($article->title, 40) }}"
                    class="rounded-xl w-full h-[166px] object-cover object-center" />
            </div>
        @endif
        <div class="pt-4">
            <div class="flex items-center mb-1.5 {{ $article->getCategoryName(1) ? 'justify-between' : 'justify-end' }}">
                @if ($article->getCategoryName(1))
                    <span class="tags !border-0">{{ ucfirst($article->getCategoryName(1)->first()->name) }}</span>
                @endif

                <span class="flex items-center justify-center opacity-0 group-hover:opacity-100 transition-all duration-500 ease-in-out">
                    <x-icon-right-top-arrow />
                </span>

            </div>
            <h4 class="font-medium text-base leading-6 tracking-[-0.176px] text-black-1200">
                {{ str()->limit($article->post_title, 35) }}
            </h4>

            <div class="flex items-center gap-2 mt-3">
                @if ($article->author->getFirstMediaUrl('avatar'))
                    <span class="flex items-center justify-center border border-solid border-gray-1200 rounded-full w-8 h-8">
                        {{-- <a href="{{ route('journal.author', ['slug' => $article->author->slug]) }}" target="{{ $target }}"> --}}
                        <img src="{{ $article->author->getFirstMediaUrl('avatar', 'thumb') }}"
                            alt="{{ $article->getAuthorName() }}"
                            class="w-full h-full rounded-full" />
                        {{-- </a> --}}
                    </span>
                @else
                    <span class="flex items-center justify-center border border-solid border-gray-1200 rounded-full w-8 h-8">
                        <img src="{{ $article->author->getFirstMediaUrl('logo', 'thumb') }}"
                            alt="{{ $article->author->name }}"
                            class="w-full h-full rounded-full" />
                    </span>
                @endif
                @if ($article->author()->exists())
                    <div class="flex-1 w-full">
                        <h5 class="text-mid-gray font-medium text-xs leading-4">{{ str()->limit($article->getAuthorName(), 15) }}</h5>
                        <p class="text-gray-1500 font-medium text-[11px] leading-2 mt-0.5 tracking-[0.32px]">{{ $article->created_at->format('M d, Y') }}</p>
                    </div>
                @endif
            </div>
        </div>
    </a>
</div>
