@props(['post'])
@php
    $article_image = $post->getFirstMediaUrl('featured_image', 'thumb');
@endphp

<div>
    <a href="{{ route('journal.show', ['slug' => $post->slug]) }}" class="flex flex-col p-6 bg-white rounded-2xl border border-solid transition-all duration-500 ease-in-out group hover:shadow-10xl border-gray-1200 shadow-7xl">
        <div class="flex flex-col items-center rounded-xl border border-solid border-gray-1200">
            <img src="{{ $article_image }}"
                alt="{{ $post->post_title }}"
                class="rounded-xl w-full h-[166px] object-cover object-center" />
        </div>
        <div class="pt-4">
            <div class="flex justify-between items-center mb-1.5">
                @if ($post->getCategoryName(1)->isNotEmpty())
                    <span class="tags !border-0">
                        @include('components.frontend.blog.partials.blog-category-title', ['category' => $post->getCategoryName(1)->first()])
                    </span>
                @endif
                <span class="flex justify-center items-center ml-auto opacity-0 transition-all duration-500 ease-in-out group-hover:opacity-100">
                    <x-icon-rigth-top-arrow />
                </span>
            </div>
            <h4 class="font-medium text-base leading-6 tracking-[-0.176px]  text-black-1200">
                {{ \Illuminate\Support\Str::limit($post->post_title, 40) }}
            </h4>
            @if ($post->author)
                <div class="flex gap-2 items-center mt-3">
                    <span class="flex justify-center items-center w-8 h-8 rounded-full border border-solid border-gray-1200">
                        <x-frontend.member.profile.partials.profile-avatar :user="$post->author" class="rounded-full" />
                    </span>
                    <div class="flex-1 w-full">
                        <h5 class="text-xs font-medium leading-4 text-mid-gray">{{ $post->getAuthorName() }}</h5>
                        @if ($post->created_at)
                            <p class="text-gray-1500 font-medium text-[11px] leading-2 mt-0.5 tracking-[0.32px]">
                                {{ $post->created_at->format('M d, Y') }}
                            </p>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    </a>
</div>
