@if ($categoriesList->isNotEmpty())
    @foreach ($categoriesList as $parentCategory)
        @php
            $parentClass = $loop->last ? '' : 'border-b border-solid border-gray-1600';
        @endphp
        <div class="py-6 {{ $parentClass }}">
            <div x-data="{ open{{ $parentCategory->id }}: true }">
                <a href="javascript:void(0)"
                    class="flex justify-between items-center collapse-btn"
                    @click="open{{ $parentCategory->id }} = !open{{ $parentCategory->id }}">
                    <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                        {{ $parentCategory->name }}
                    </h4>
                    <span class="flex justify-center items-center w-5 h-5" :class="{ 'rotate-180': open{{ $parentCategory->id }} }">
                        <x-icon-down-arrow-outline />
                    </span>
                </a>

                <div class="mt-3 filter-collapse"
                    x-show="open{{ $parentCategory->id }}"
                    x-transition:enter="transition duration-300 ease-in-out"
                    x-transition:enter-start="opacity-0 transform -translate-y-2 ease-in-out"
                    x-transition:enter-end="opacity-100 transform translate-y-0 ease-in-out"
                    x-transition:leave="transition duration-300 ease-in-out"
                    x-transition:leave-start="opacity-100 transform translate-y-0 ease-in-out"
                    x-transition:leave-end="opacity-0 transform -translate-y-2 ease-in-out">
                    <ul>
                        @foreach ($parentCategory->children as $childCategory)
                            @php
                                $postCount = $childCategory->posts()->published()->count();
                            @endphp
                            @if ($postCount > 0)
                                <li>
                                    <div class="flex items-center px-2">
                                        <a id="category{{ $childCategory->slug }}"
                                            href="{{ route('journal.category', $childCategory->slug) }}"
                                            class="flex items-center gap-2 text-black-1200 hover:text-primary-blue font-normal active:text-violet-700">{{ $childCategory->name }}
                                            <span class="text-xs leading-4 ">({{ $postCount }})</span>
                                        </a>
                                    </div>
        
                                    <ol class="my-2">
                                        @foreach ($childCategory->children as $child)
                                            @php
                                                $childPostCount = $child->posts()->published()->count();
                                            @endphp
                                            @if ($childPostCount > 0)
                                                <li class="mb-4">
                                                    <a href="{{ $child->permalink }}" class="text-[15px] font-semibold leading-[18px] tracking-[0.48px] text-gray-1500 hover:text-red-1300 pl-3.5 relative after:absolute after:content-[''] after:left-0 after:top-1/2 after:-translate-y-1/2 after:w-1.5 after:h-1.5 after:bg-gray-1600 after:rounded-full">
                                                        {{ $child->name }} ({{ $childPostCount }})
                                                    </a>
                                                </li>
                                            @endif
                                        @endforeach
                                    </ol>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endforeach
@endif
