@if ($categoriesList->isNotEmpty())
    @foreach ($categoriesList as $parentCategory)
        @php
            $parentClass = $loop->last ? '' : 'border-b border-solid border-gray-1600';
        @endphp
        <div class="py-6 {{ $parentClass }}">
            <div x-data="{ open{{ $parentCategory->id }}: true }">
                <a href="javascript:void(0)"
                    class="flex justify-between items-center collapse-btn"
                    @click="open{{ $parentCategory->id }} = !open{{ $parentCategory->id }}">
                    <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                        {{ $parentCategory->name }}
                    </h4>
                    <span class="flex justify-center items-center w-5 h-5" :class="{ 'rotate-180': open{{ $parentCategory->id }} }">
                        <x-icon-down-arrow-outline />
                    </span>
                </a>

                <div class="mt-3 filter-collapse"
                    x-show="open{{ $parentCategory->id }}"
                    x-transition:enter="transition duration-300 ease-in-out"
                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                    x-transition:enter-end="opacity-100 transform translate-y-0">
                    <ul>
                        @foreach ($parentCategory->children as $childCategory)
                            @php
                                $postCount = $childCategory->posts()->published()->count();
                            @endphp
                            @if ($postCount > 0)
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="category-{{ $childCategory->id }}"
                                            type="checkbox"
                                            value="{{ $childCategory->slug }}"
                                            wire:model="category"
                                            wire:change="applySearch"
                                            name="category[]"
                                            class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="category-{{ $childCategory->id }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                            {{ $childCategory->name }}
                                            <span class="text-xs leading-4 text-mid-gray">({{ $postCount }})</span>
                                        </label>
                                    </div>
                                    <ol class="my-4">
                                        @foreach ($childCategory->children as $child)
                                            @php
                                                $childPostCount = $child->posts()->published()->count();
                                            @endphp
                                            @if ($childPostCount > 0)
                                                <li class="mb-4">
                                                    <a href="{{ $child->permalink }}" class="text-[15px] font-semibold leading-[18px] tracking-[0.48px] text-gray-1500 hover:text-red-1300 pl-3.5 relative after:absolute after:content-[''] after:left-0 after:top-1/2 after:-translate-y-1/2 after:w-1.5 after:h-1.5 after:bg-gray-1600 after:rounded-full">
                                                        {{ $child->name }} ({{ $childPostCount }})
                                                    </a>
                                                </li>
                                            @endif
                                        @endforeach
                                    </ol>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endforeach
@endif
