@props(['classified', 'target' => '_self'])
@php
    use ProtoneMedia\LaravelFFMpeg\Support\FFMpeg;
    use Illuminate\Support\Facades\Storage;
    use Illuminate\Support\Number;

    // Get the first video media item
    $videoMedia = $classified->getMedia('video')->first();

    $videoFileUrl = $videoMedia ? $videoMedia->getFullUrl() : null;
    // $videoPath = $videoMedia ? $videoMedia->getPath() : null;
    // $videoRelativePath = $videoMedia ? $videoMedia->getPathRelativeToRoot() : null;
    $duration = 0;

    if ($videoMedia) {
        $duration = FFMpeg::fromDisk($videoMedia->disk)->open($videoMedia->getPathRelativeToRoot())->getDurationInSeconds();
        $duration = gmdate('i:s', $duration);
    }
    $phone = $classified->user->profile?->phone;

    $googleMapsLink = esp_google_maps_location_link($classified->latitude, $classified->longitude);
@endphp
<div class="flex relative flex-col gap-5 p-6 mb-6 bg-white rounded-2xl border border-solid xl:gap-4 md:gap-3.5 md:flex-row border-gray-1200 shadow-10xl xl:p-6 md:p-4">
    <div class="xl:max-w-[262px] md:max-w-[190px] max-w-full w-full md:max-h-[270px] rounded-xl border border-solid border-gray-1200 relative">
        <div class="h-full rounded-xl swiper ClassifiedsSwiper">
            <div class="h-full rounded-xl swiper-wrapper">
                @if ($hasImages)
                    @if ($videoFileUrl)
                        <div class="swiper-slide !h-auto rounded-xl">
                            <a href="javascript:void(0)"
                                onclick="Livewire.dispatch('openModal', { component: 'frontend.classified.modal.classified-video-modal', arguments: { classified: {{ $classified->id }} }})"
                                class="flex justify-center items-center h-full">
                                <img src="{{ $videoMedia->getUrl('thumb') }}"
                                    alt="{{ $classified->title }}"
                                    class="object-cover object-center w-full h-full rounded-xl"
                                    loading="lazy" />
                                @if ($duration)
                                    <span class="absolute right-3 bottom-3 text-white text-[13px] font-bold leading-[130%] h-5 rounded-[40px] bg-blue-1500/[0.3] backdrop-blur-[10px] inline-flex items-center justify-center px-1.5">{{ $duration }}</span>
                                @endif
                                @if ($videoMedia)
                                    <div class="flex absolute top-1/2 left-1/2 justify-center items-center w-10 h-10 rounded-full opacity-75 transition-all duration-500 ease-in-out -translate-x-1/2 -translate-y-1/2 group-hover:opacity-100 group-hover:visible bg-gray-1400 shadow-11xl">

                                        <x-icon-play-fill />
                                    </div>
                                @endif
                            </a>
                        </div>
                    @endif
                    @if ($featuredImage)
                        <div class="swiper-slide !h-auto rounded-xl">
                            <a href="{{ route('classified.show', $classified->slug) }}"
                                class="flex justify-center items-center h-full"
                                target="{{ $target }}">
                                <img src="{{ $featuredImage }}"
                                    alt="{{ $classified->title }}"
                                    class="object-cover object-center w-full h-full rounded-xl"
                                    loading="lazy" />
                            </a>
                        </div>
                    @endif
                    @foreach ($galleryImages as $galleryImage)
                        <div class="swiper-slide !h-auto rounded-xl">
                            <a href="{{ route('classified.show', $classified->slug) }}"
                                class="flex justify-center items-center h-full"
                                target="{{ $target }}">
                                <img src="{{ $galleryImage->getUrl('thumb') }}"
                                    alt="{{ $classified->title }}"
                                    class="object-cover object-center w-full h-full rounded-xl"
                                    loading="lazy" />
                            </a>
                        </div>
                    @endforeach
                @endif
            </div>
            <div class="swiper-pagination swiper-pagination2"></div>
        </div>

        <a href="#" class="flex absolute top-1/2 left-1/2 justify-center items-center w-10 h-10 bg-white rounded-full -translate-x-1/2 -translate-y-1/2"> <img src="images/play-icon.svg" alt="" /></a>
    </div>
    <div class="flex flex-col flex-1 justify-between w-full">
        <div class="flex justify-between items-start">
            <div class="">
                <span class="feature-tag">{{ __('Featured') }}</span>
                <h4 class="2xl:text-[32px] xl:text-2xl text-xl mt-1.5 font-medium xl:leading-10 leading-6 tracking-[-0.08px] text-black-1200">
                    <a href="{{ route('classified.show', $classified->slug) }}" target="{{ $target }}">
                        {{ $classified->title }}
                    </a>
                </h4>
                <h5 class="flex gap-2 items-center mt-2 text-2xl font-semibold leading-7 text-primary-blue xl:text-2xl md:text-xl sm:mt-1">
                    {{ $priceFormatted }}
                    @if ($isReduced)
                        <span class="text-sm font-medium leading-5 tracking-[-0.096px] text-gray-1500 line-through flex  items-center">{{ $reducedPriceFormatted }}</span>
                    @endif
                </h5>
            </div>

        </div>
        <div class="gap-6 mt-3 xl:gap-0 md:gap-4 md:mt-0">
            <h5 class="text-base font-medium leading-7 text-black-1200 xl:text-xl">
                {{ $classified->user->memberName() }}
            </h5>
            @if ($classified->getClassifiedCondition() || $classified->isNew() || $classified->getCategories(limit: 2)->isNotEmpty())
                <ul class="flex flex-wrap gap-2 items-center mt-2">
                    @include('components.frontend.classified.partials.classified-card.classified-categories')
                </ul>
            @endif
            @if ($classified->getAddress() || $classified->updated_at)
                <ul class="flex flex-wrap gap-1.5 items-center mt-2 sm:gap-2">
                    @include('components.frontend.classified.partials.classified-card.card-location-posted')
                </ul>
            @endif
            <ul class="grid grid-cols-2 gap-3 mt-2.5 md:grid-cols-3 xl:mt-6">
                <li>
                    <x-frontend.includes.contact-modal-button :user="$classified->user" class="group w-full text-mid-gray hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                        <x-icon-chat-outline-v2 class="text-mid-gray hover:text-black-1200" />
                        {{ __('Get Quote') }}
                    </x-frontend.includes.contact-modal-button>
                </li>
                @if (!empty($googleMapsLink))
                    <li>
                        <a href="{{ $googleMapsLink }}"
                            target="{{ $target }}"
                            class="group w-full text-mid-gray hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                            <x-icon-map-direction />
                            {{ __('Directions') }}
                        </a>
                    </li>
                @endif
                @if (!empty($phone))
                    <li>
                        <a href="tel:{{ $phone }}" class="group w-full text-mid-gray hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                            <x-icon-phone-outline />
                            {{ __('Call Now') }}
                        </a>
                    </li>
                @endif
            </ul>
        </div>
    </div>
</div>
