@props(['classified', 'target' => '_self'])

<div class="bg-white Classifield-card xl:gap-4 md:gap-3.5 gap-4 mb-5 shadow-34xl relative flex md:flex-row flex-col border border-solid border-gray-1200 rounded-2xl xl:p-6 p-4">
    <div class="xl:max-w-[262px] md:max-w-[190px] max-w-full w-full h-[166px]  rounded-xl border border-solid border-gray-1200 relative">
        @if ($classified->isFlashSale())
            <span class="absolute z-50 left-3 top-3 inline-flex items-center justify-center text-xs font-medium leading-4 bg-red-1000 rounded-full text-white h-6 w-[89px] gap-1.5">
                <x-icon-flash-icon-outline />
                {{ __('Flash Sale') }}
            </span>
        @endif
        <div class="swiper ClassifieldsSwiper rounded-xl h-full">
            <div class="swiper-wrapper rounded-xl h-full">
                @if ($hasImages)
                    @if ($featuredImage)
                        <div class="swiper-slide !h-auto rounded-xl">
                            <a href="{{ $featuredImage }}"
                                class="flex justify-center items-center h-full"
                                target="{{ $target }}">
                                <img src="{{ $featuredImage }}"
                                    alt="{{ $classified->title }}"
                                    loading="lazy"
                                    class="w-full h-full object-cover object-center rounded-xl" />
                            </a>
                        </div>
                    @endif
                    @foreach ($galleryImages as $galleryImage)
                        <div class="swiper-slide !h-auto rounded-xl">
                            <a href="{{ $galleryImage->getUrl('thumb') }}"
                                class="flex justify-center items-center h-full"
                                target="{{ $target }}">
                                <img src="{{ $galleryImage->getUrl('thumb') }}"
                                    alt="{{ $classified->title }}"
                                    loading="lazy"
                                    class="w-full h-full object-cover object-center rounded-xl" />
                            </a>
                        </div>
                    @endforeach
                @else
                    <div class="swiper-slide !h-auto rounded-xl">
                        <a href="{{ $featuredImage }}"
                            class="flex justify-center items-center h-full"
                            target="{{ $target }}">
                            <img src="{{ $featuredImage }}"
                                alt="{{ $classified->title }}"
                                loading="lazy"
                                class="w-full h-full object-cover object-center rounded-xl" />
                        </a>
                    </div>
                @endif
            </div>
            <div class="swiper-pagination swiper-pagination2"></div>
        </div>
    </div>
    <div class="flex-1 w-full flex flex-col {{ $classified->isFlashSale() ? 'justify-between' : '' }}">
        <div class="flex items-start justify-between {{ !$classified->isFlashSale() ? 'sm:relative' : '' }}">
            <div class="">
                <a href="{{ route('classified.show', $classified->slug) }}"
                    target="{{ $target }}"
                    class="cursor-pointer">
                    <h4 class="{{ $classified->isFlashSale() ? 'xl:text-xl md:text-base text-xl font-medium leading-6 text-black-1200' : '2xl:text-xl xl:text-base text-xl font-medium leading-7 text-black-1200' }}">
                        {{ str()->limit($classified->title, 30) }}
                    </h4>
                </a>
                @if ($reducedPrice > 0)
                    <h5 class="text-black-1200 xl:text-2xl md:text-xl text-2xl font-semibold leading-7 flex items-center {{ $classified->isFlashSale() ? '' : 'mt-1' }}">
                        {{ $reducedPrice > 0 ? $reducedPriceFormatted : $priceFormatted }}
                        <span class="text-sm font-medium leading-5 tracking-[-0.096px] text-gray-1500 line-through md:flex hidden items-center px-2">
                            {{ $reducedPrice > 0 ? $priceFormatted : $reducedPriceFormatted }}
                        </span>
                    </h5>
                @else
                    <h5 class="text-black-1200 xl:text-2xl md:text-xl text-2xl font-semibold leading-7 flex items-center {{ $classified->isFlashSale() ? '' : 'mt-1' }}">
                        {{ $priceFormatted }}
                    </h5>
                @endif
            </div>
            
            <ul class="flex items-center gap-3 absolute {{ $classified->isFlashSale() ? 'flex items-center gap-3 md:static absolute right-9 top-9 z-50' : '2xl:right-0 2xl:top-0 xl:-right-4 xl:-top-4 sm:right-0 sm:top-0 right-7 top-7 z-50' }}">
                <li>
                    <x-frontend.includes.share-modal-button :user="$classified->user"
                        url="{{ $classified->permalink }}"
                        target="share-modal"
                        toggle="share-modal"
                        type="classified"
                        class="group bg-white shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 transition-all duration-500 ease-in-out border border-solid border-gray-1200 xl:w-9 w-8 xl:h-9 h-8 rounded-full flex items-center justify-center">
                        <x-icon-share-icon />
                    </x-frontend.includes.share-modal-button>
                </li>
                <li>

                    <x-frontend.includes.add-favorite-button module="classified"
                        :modelId="$classified->uuid"
                        :isFavorite="$classified->isFavorite()"
                        class="group bg-white shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 transition-all duration-500 ease-in-out border border-solid border-gray-1200 xl:w-9 w-8 xl:h-9 h-8 rounded-full flex items-center justify-center">
                        <x-icon-heart-circle-outline />
                    </x-frontend.includes.add-favorite-button>

                </li>
            </ul>
        </div>

        @if ($classified->isFlashSale())
            <div class="flex md:flex-row flex-col row:items-center md:items-end items-start justify-between xl:gap-0 md:gap-4 gap-6 md:mt-0 mt-4">
                <div class="">
                    @if ($classified->getClassifiedCondition() || $classified->isNew() || $classified->getCategories(limit: 2)->isNotEmpty())
                        <ul class="flex items-center gap-2">
                            @include('components.frontend.classified.partials.classified-card.classified-categories')
                        </ul>
                    @endif
                    @if ($classified->getAddress() || $classified->updated_at)
                        <ul class="flex mt-3 items-center flex-wrap sm:gap-2 gap-1.5">
                            @include('components.frontend.classified.partials.classified-card.card-location-posted')
                        </ul>
                    @endif
                </div>

                <div class="md:w-auto w-full"
                    x-data="countdown('{{ esp_format_date_for_js_countdown_simple($classified->discount_end) }}')"
                    x-init="$nextTick(() => { /* countdown auto-starts in init() */ })">
                    <div id="countdown" class="flex items-center justify-between mb-3 md:max-w-full max-w-[200px] mx-auto">
                        <div class="flex items-center justify-center flex-col">
                            <span x-text="formatTime(days)" class="text-sm font-semibold text-center leading-5 text-black-1200">{{ __('00') }}</span>
                            <div class="text-xs font-medium leading-4 text-gray-1500">{{ __('Days') }}</div>
                        </div>
                        <div class="text-lg font-bold leading-[130%] text-blue-1600">{{ __(':') }}</div>
                        <div class="flex items-center justify-center flex-col">
                            <span x-text="formatTime(hours)" class="text-sm font-semibold text-center leading-5 text-black-1200">{{ __('00') }}</span>
                            <div class="text-xs font-medium leading-4 text-gray-1500">{{ __('Hrs') }}</div>
                        </div>
                        <div class="text-lg font-bold leading-[130%] text-blue-1600">{{ __(':') }}</div>
                        <div class="flex items-center justify-center flex-col">
                            <span x-text="formatTime(minutes)" class="text-sm font-semibold text-center leading-5 text-black-1200">{{ __('00') }}</span>
                            <div class="text-xs font-medium leading-4 text-gray-1500">{{ __('Mins') }}</div>
                        </div>
                        <div class="text-lg font-bold leading-[130%] text-blue-1600">{{ __(':') }}</div>
                        <div class="flex items-center justify-center flex-col">
                            <span x-text="formatTime(seconds)" class="text-sm font-semibold text-center leading-5 text-black-1200">{{ __('00') }}</span>
                            <div class="text-xs font-medium leading-4 text-gray-1500">{{ __('Secs') }}</div>
                        </div>
                    </div>
                    <a href="{{ route('classified.show', $classified->slug) }}" class="primary-btn md:w-[180px] w-full">
                        <x-icon-flash-outline-v2 />
                        {{ __('View Flash Deal') }}
                    </a>
                </div>

            </div>
        @else
            @if ($classified->getClassifiedCondition() || $classified->isNew() || $classified->getCategories(limit: 2)->isNotEmpty())
                <ul class="flex sm:flex-nowrap flex-wrap sm:items-center items-start  gap-2 md:mt-[22px] mt-4">
                    @include('components.frontend.classified.partials.classified-card.classified-categories')
                </ul>
            @endif
            <div class="flex sm:flex-row flex-col sm:items-center items-start justify-between  gap-0 mt-3">
                @if ($classified->getAddress() || $classified->updated_at)
                    <ul class="flex sm:mb-0 mb-6 items-start sm:flex-col flex-row sm:flex-nowrap flex-wrap">
                        @include('components.frontend.classified.partials.classified-card.card-location-posted')
                    </ul>
                @endif

                <a href="classifieds-detail.php" class="text-white text-sm font-medium leading-5 gap-2 tracking-[-0.084px] w-[133px] h-10! rounded-[999px] secondary-btn-gradient sm:!flex !hidden items-center justify-center shadow-32xl!">
                    <span class="flex items-center justify-center w-5 h-5">
                        <x-icon-right-top-arrow />
                    </span>
                    {{ __('View Listing') }}
                </a>
                @if ($classified->isFlashSale())
                    <a href="{{ route('classified.show', $classified->slug) }}" class="secondary-btn sm:!hidden !flex w-full">
                        <x-icon-flash-outline-v2 />
                        {{ __('View Listing') }}
                    </a>
                @endif
            </div>
        @endif
    </div>
</div>
