@props(['classified', 'target' => '_self'])
@php
    $featuredImage = $classified->getFirstMediaUrl('featured_image');
    $galleryImages = $classified->getMedia('gallery');
    $hasImages = $featuredImage || $galleryImages->isNotEmpty();
    $price = $classified->price ? $classified->price : 0;
    $priceFormatted = esp_currency_formated(price: $price, currency: 'USD', locale: 'en');
    $reducedPrice = $classified->discount_price ? $classified->discount_price : 0;
    $isReduced = $reducedPrice !== 0 && $reducedPrice < $price;
    $priceFormatted = esp_currency_formated(price: $price);
    $reducedPriceFormatted = esp_currency_formated(price: $reducedPrice);
@endphp

@if($classified->isFlashSale())
    @include('components.frontend.classified.classified-flash-card-v1', ['classified' => $classified, 'target' => $target])
@else
    @include('components.frontend.classified.classified-simple-card-v2', ['classified' => $classified, 'target' => $target])
@endif

