@props(['classified', 'target' => '_self'])
@php
    $featuredImage = $classified->getFirstMediaUrl('featured_image');
    $galleryImages = $classified->getMedia('gallery');
    $hasImages = $featuredImage || $galleryImages->isNotEmpty();
    $price = $classified->price ? $classified->price : 0;
    $priceFormatted = esp_currency_formated(price: $price, currency: 'USD', locale: 'en');
    $reducedPrice = $classified->discount_price ? $classified->discount_price : 0;
    $isReduced = $reducedPrice !== 0 && $reducedPrice < $price;
    $priceFormatted = esp_currency_formated(price: $price);
    $reducedPriceFormatted = esp_currency_formated(price: $reducedPrice);
@endphp
@if ($classified->is_featured)
    @include('components.frontend.classified.classified-card-featured', ['target' => $target])
@else
    @include('components.frontend.classified.classified-card-simple', ['target' => $target])
@endif
