@props(['classified', 'target' => '_self'])
@php
    $featuredImage = $classified->getFirstMediaUrl('featured_image');
    $galleryImages = $classified->getMedia('gallery');
    $hasImages = $featuredImage || $galleryImages->isNotEmpty();
    $price = $classified->price ? $classified->price : 0;
    $priceFormatted = esp_currency_formated(price: $price, currency: 'USD', locale: 'en');
    $reducedPrice = $classified->discount_price ? $classified->discount_price : 0;
    $isReduced = $reducedPrice !== 0 && $reducedPrice < $price;
    $priceFormatted = esp_currency_formated(price: $price);
    $reducedPriceFormatted = esp_currency_formated(price: $reducedPrice);
@endphp
<div class="bg-white border border-solid border-gray-1200 shadow-19xl  rounded-2xl md:p-6 p-4">
    <div class="w-full h-[196px] relative">
        @if ($classified->isFlashSale())
            <span class="absolute z-50 left-3 top-3 inline-flex items-center justify-center text-xs font-medium leading-4 bg-red-1000 rounded-full text-white h-6 w-[89px] gap-1.5">
                <x-icon-flash-icon-outline />
                {{ __('Flash Sale') }}
            </span>
        @endif

        <div class="swiper flashClassifieldsSwiper rounded-xl h-full">
            <div class="swiper-wrapper rounded-xl lg:h-full h-auto">
                @if ($hasImages)
                    @if ($featuredImage)
                        <div class="swiper-slide !h-auto rounded-xl">
                            <a href="{{ route('classified.show', $classified->slug) }}" target="{{ $target }}">
                                <img src="{{ $featuredImage }}"
                                    alt="{{ $classified->title }}"
                                    class="w-full h-full object-cover object-center rounded-xl" 
                                    loading="lazy" />
                            </a>
                        </div>
                    @endif
                    @foreach ($galleryImages as $galleryImage)
                        <div class="swiper-slide !h-auto rounded-xl">
                            <a href="{{ route('classified.show', $classified->slug) }}" target="{{ $target }}">
                            <img src="{{ $galleryImage->getUrl('thumb') }}"
                                alt="{{ $classified->title }}"
                                class="w-full h-full object-cover object-center rounded-xl" />
                            </a>
                        </div>
                    @endforeach
                @else
                    <div class="swiper-slide !h-auto rounded-xl">
                        <a href="{{ route('classified.show', $classified->slug) }}" target="{{ $target }}">
                            <img src="{{ $featuredImage }}"
                                alt="{{ $classified->title }}"
                                class="w-full h-full object-cover object-center rounded-xl"
                                loading="lazy" />
                        </a>
                    </div>
                @endif
            </div>
            <div class="swiper-pagination swiper-pagination2"></div>
        </div>
        <ul class="flex items-center gap-3 absolute right-3 top-3 z-50">
            <li>
                <x-frontend.includes.share-modal-button :user="$classified->user"
                    url="{{ $classified->permalink }}"
                    target="share-modal"
                    toggle="share-modal"
                    type="classified"
                    class="group bg-white shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 transition-all duration-500 ease-in-out border border-solid border-gray-1200 w-8 h-8 rounded-full flex items-center justify-center">
                    <x-icon-share-icon />
                </x-frontend.includes.share-modal-button>
            </li>
            <li>
                <x-frontend.includes.add-favorite-button module="classified"
                    :modelId="$classified->uuid"
                    :isFavorite="$classified->isFavorite()"
                    class="group bg-white shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 transition-all duration-500 ease-in-out border border-solid border-gray-1200 w-8 h-8 rounded-full flex items-center justify-center">
                    <x-icon-heart-circle-outline />
                </x-frontend.includes.add-favorite-button>

            </li>
        </ul>
    </div>
    <div class="pt-6">
        <h4 class="text-black-1200 font-medium md:text-xl text-lg md:leading-7 leading-6 capitalize">
            {{ str()->limit($classified->title, 50) }}
        </h4>
        @if ($reducedPrice > 0)
            <h5 class="text-black-1200 text-2xl font-semibold leading-7 flex items-center gap-2 mt-1">
                {{ $reducedPrice > 0 ? $reducedPriceFormatted : $priceFormatted }}
                <span class="text-sm font-medium leading-5 tracking-[-0.084px] text-gray-1500 line-through md:flex hidden items-center">
                    {{ $reducedPrice > 0 ? $priceFormatted : $reducedPriceFormatted }}
                </span>
            </h5>
        @else
            <h5 class="text-black-1200 text-2xl font-semibold leading-7 flex items-center gap-2 mt-1">
                {{ $priceFormatted }}
            </h5>
        @endif
        @if ($classified->getClassifiedCondition() || $classified->isNew() || $classified->getCategories(limit: 2)->isNotEmpty())
            <ul class="flex items-center gap-2 mt-4">
                @include('components.frontend.classified.partials.classified-card.classified-categories')
            </ul>
        @endif
        @if ($classified->getAddress() || $classified->updated_at)
            <ul class="flex mt-3.5 items-center flex-wrap gap-2">
                @if ($classified->getAddress())
                    <li class="text-mid-gray font-medium text-xs flex items-center gap-1">
                        <span class="flex items-center justify-center w-5 h-5">
                            <x-icon-location-outline-v2 />
                        </span>
                        {{ $classified->getAddress('area') }}
                    </li>
                @endif
                @if ($classified->updated_at)
                    <li class="text-mid-gray font-medium text-xs flex items-center gap-1">
                        <span class="flex items-center justify-center w-5 h-5">
                            <x-icon-calendar-icon3 />
                        </span>
                        {{ __('Updated') }}: {{ $classified->updated_at->diffForHumans() }}
                    </li>
                @endif
            </ul>
        @endif
        <div class="bg-red-1200 p-3 mb-6 rounded-lg md:mt-6 mt-[26px]">
            <div class="countdown flex items-center justify-between max-w-[184px] w-full mx-auto">
                <div class="flex items-center justify-center flex-col">
                    <span class="days text-sm font-semibold text-center leading-5 text-red-1000">02</span>
                    <div class="text-xs font-medium leading-4 text-gray-1500">Days</div>
                </div>
                <div class="text-lg font-bold leading-[130%] text-blue-1600">:</div>
                <div class="flex items-center justify-center flex-col">
                    <span class="hours text-sm font-semibold text-center leading-5 text-red-1000">05</span>
                    <div class="text-xs font-medium leading-4 text-gray-1500">Hrs</div>
                </div>
                <div class="text-lg font-bold leading-[130%] text-blue-1600">:</div>
                <div class="flex items-center justify-center flex-col">
                    <span class="minutes text-sm font-semibold text-center leading-5 text-red-1000">10</span>
                    <div class="text-xs font-medium leading-4 text-gray-1500">Mins</div>
                </div>
                <div class="text-lg font-bold leading-[130%] text-blue-1600">:</div>
                <div class="flex items-center justify-center flex-col">
                    <span class="seconds text-sm font-semibold text-center leading-5 text-red-1000">00</span>
                    <div class="text-xs font-medium leading-4 text-gray-1500">Secs</div>
                </div>
            </div>
        </div>
        <a href="{{ route('classified.show', $classified->slug) }}" 
            class="primary-btn secondary-btn-gradient !border-none !h-[52px] shadow-27xl !text-white w-full">
            <x-icon-flash-outline-v2 />
            {{ __('Browse Flash Deal') }}
        </a>
    </div>

</div>
