@php
    use Illuminate\Support\Str;
@endphp
@if ($classified->getClassifiedCondition())
    <li><a href="{{ route('classified.index', ['condition' => $classified->getClassifiedCondition()]) }}" class="tags active">{{ $classified->getClassifiedCondition() }}</a></li>
@endif
@if ($classified->isNew())
    <li><a href="#" class="tags active">{{ __('Just Listed') }}</a></li>
@endif
@if ($classified->getCategories(limit: 2)->isNotEmpty())
    @foreach ($classified->getCategories(limit: 2) as $category)
        <li>
            <a href="{{ route('classified.index', ['category' => $category->slug]) }}" class="tags">
                @include('components.frontend.classified.partials.classified-card.classified-category-title', ['category' => $category])
            </a>
        </li>
    @endforeach
@endif
