<div class="bg-white border-solid lg:border border-gray-1200 lg:shadow-5xl lg:rounded-2xl">
    <div class="flex justify-between items-center px-6 pt-6 pb-3 border-b border-solid lg:pb-0 lg:border-0 border-gray-1200">
        <h6 class="hidden lg:block">
            {{ __('Filter by') }}
        </h6>
        <h6 class="flex gap-3 items-center lg:hidden">
            <x-icon-list-bars />
            {{ __('Filters') }}
            <span class="flex justify-center items-center w-6 h-6 text-xs font-medium text-white rounded-full bg-primary-blue">
                0
            </span>
        </h6>
        <div class="flex gap-3 items-center">
            <a href="javascript:void(0)"
                x-on:click="$wire.resetFilters(); openFilter = false;"
                class="flex text-primary-blue gap-2 items-center justify-center font-medium text-sm tracking-[-0.096px]">
                <x-icon-close-icon class="hidden lg:block" />
                {{ __('Clear all') }}
            </a>
            <a href="javascript:void(0)"
                @click="openFilter = false"
                class="flex justify-center items-center w-6 h-6 lg:hidden filter-close">
                <x-icon-close-icon />
            </a>
        </div>
    </div>
    <div class="lg:px-px lg:h-auto lg:overflow-y-auto h-[calc(100vh_-_154px)] overflow-y-scroll">
        <div class="px-6 py-8 lg:py-6">
            <form wire:submit.prevent="applySearch">
                {{-- Search --}}
                <div class="pb-6 border-b border-solid border-gray-1600">
                    <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Search') }}</h4>
                    <div class="relative mt-1">
                        <input type="text"
                            wire:model.live="search"
                            class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full pl-10"
                            placeholder="{{ __('Search...') }}" />
                        <a href="javascript:void(0)" class="flex absolute left-3.5 top-1/2 justify-center items-center -translate-y-1/2">
                            <x-icon-search-icon />
                        </a>
                    </div>
                    <div class="mt-4 filter-collapse filter-widget">
                        <ul>
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="F-sales"
                                        type="checkbox"
                                        value='flash-sales'
                                        wire:model.live="flashOnly"
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="flash-sales" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                        {{ __('Flash Sales Only') }}
                                    </label>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="new-items"
                                        type="checkbox"
                                        value='new-items'
                                        wire:model.live="newItems"
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="new-items" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                        {{ __('New Items') }}
                                    </label>
                                </div>
                            </li>
                            {{-- <li>
                                <div class="flex items-center mb-2">
                                    <input id="local-pickup"
                                        type="checkbox"
                                        value='local-pickup'
                                        wire:model.live="localPickup"
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="local-pickup" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                        {{ __('Local Pickup') }}
                                    </label>
                                </div>
                            </li> --}}
                        </ul>
                    </div>
                </div>

                {{-- Location filters --}}
                <div class="py-6 border-b border-solid border-gray-1600">
                    <a href="javascript:void(0)"
                        @click="openLocation = !openLocation"
                        class="flex justify-between items-center collapse-btn">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Location') }}</h4>
                        <span class="flex justify-center items-center w-5 h-5">
                            <x-icon-down-arrow-outline />
                        </span>
                    </a>
                    <div class="mt-3 filter-collapse filter-widget"
                        x-show="openLocation"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0">
                        @if ($countryList->isNotEmpty())
                            <ul wire:ignore>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="country-{{ __('all') }}"
                                            type="radio"
                                            value=""
                                            wire:model.live="country"
                                            class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="country-{{ __('all') }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                            {{ __('All') }}
                                            <span class="text-xs leading-4 text-mid-gray">{{ $countryList->sum('classifieds_count') }}</span>
                                        </label>
                                    </div>
                                </li>
                                @foreach ($countryList as $country)
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="country-{{ $country->slug }}"
                                                type="radio"
                                                wire:model.live="country"
                                                value="{{ $country->slug }}"
                                                class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="country-{{ $country->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                {{ $country->country_name }}
                                                <span class="text-xs leading-4 text-mid-gray">{{ $country->classifieds_count }}</span>
                                            </label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                            @if ($stateList->isNotEmpty())
                                <div class="mb-4">
                                    <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('State') }}</h4>
                                    <div class="relative mt-1">
                                        <select wire:model.live="state" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                            <option>{{ __('Select State') }}</option>
                                            @foreach ($stateList as $state)
                                                <option value="{{ $state->slug }}">{{ $state->state_name }}</option>
                                            @endforeach
                                        </select>
                                        <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2">
                                            <x-icon-down-arrow-outline />
                                        </span>
                                    </div>
                                </div>
                            @endif
                            @if (!empty($state))
                                <div>
                                    <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                        {{ __('City or Zip') }}
                                    </h4>
                                    <div class="relative mt-1" x-data="{ lat: null, lng: null }">
                                        <input id="city-input-{{ $this->id() }}"
                                            wire:model="city"
                                            type="text"
                                            placeholder="Enter city or zip"
                                            class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3" />
                                        @if ($city)
                                            <button type="button"
                                                x-on:click="$wire.set('city', null); $wire.set('lat', null); $wire.set('lng', null);"
                                                class="absolute right-4 top-1/2 text-gray-500 -translate-y-1/2 hover:text-gray-700 focus:outline-none"
                                                title="{{ __('Clear') }}">
                                                <x-icon-clear-field class="w-5 h-5" />
                                            </button>
                                        @endif
                                        <input type="hidden"
                                            id="lat-{{ $this->id() }}"
                                            wire:model="lat"
                                            x-model="lat" />
                                        <input type="hidden"
                                            id="lng-{{ $this->id() }}"
                                            wire:model="lng"
                                            x-model="lng" />
                                        {{-- Clear icon that only appears when there's a value --}}
                                    </div>
                                    {{-- Radius Selection --}}
                                    <div class="mt-4">
                                        <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px] mb-3">{{ __('Radius') }}</h4>
                                        <ul>
                                            @foreach ($radiusList as $radiusItem)
                                                <li>
                                                    <div class="flex items-center {{ $loop->last ? '' : 'mb-2' }}">
                                                        <input id="radius-{{ $radiusItem['id'] }}"
                                                            wire:model.live="radius"
                                                            type="radio"
                                                            value="{{ $radiusItem['id'] }}"
                                                            class="w-[18px] h-[18px] bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0" />
                                                        <label for="radius-{{ $radiusItem['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                            {{ $radiusItem['name'] }}
                                                        </label>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                        @if ($radius == 'custom')
                                            <div class="mt-3">
                                                <input type="text"
                                                    wire:model.blur="customRadius"
                                                    class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3"
                                                    placeholder="{{ __('Enter custom radius') }}" />
                                                @error('customRadius')
                                                    <span class="block mt-1 text-sm text-red-500">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        @endif
                    </div>
                </div>

                {{-- Classified Ad Type --}}
                <div class="py-6 border-b border-solid border-gray-1600">
                    <a href="javascript:void(0)"
                        @click="openClassifiedAdType = !openClassifiedAdType"
                        class="flex justify-between items-center collapse-btn">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Classified Ad Type') }}
                        </h4>
                        <span class="flex justify-center items-center w-5 h-5">
                            <x-icon-down-arrow2 />
                        </span>
                    </a>
                    <div class="mt-3 filter-collapse filter-widget"
                        x-show="openClassifiedAdType"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0">
                        <ul>
                            @foreach ($typesList->take(5) as $type)
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="type-{{ $type->slug }}"
                                            type="checkbox"
                                            value="{{ $type->slug }}"
                                            wire:model.live="type"
                                            class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="type-{{ $type->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ $type->classified_type_name }}</label>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                        @if ($typesList->count() > 5)
                            <div x-data="{ showAllTypes: false }">
                                <div x-show="showAllTypes"
                                    x-transition:enter="transition duration-300 ease-in-out"
                                    x-transition:enter-start="opacity-0 transform -translate-y-2"
                                    x-transition:enter-end="opacity-100 transform translate-y-0">
                                    <ul>
                                        @foreach ($typesList->skip(5) as $type)
                                            <li>
                                                <div class="flex items-center mb-2">
                                                    <input id="type-{{ $type->slug }}"
                                                        type="checkbox"
                                                        value="{{ $type->slug }}"
                                                        wire:model.live="type"
                                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="type-{{ $type->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ $type->classified_type_name }}</label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>

                                <a @click="showAllTypes = !showAllTypes" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                    <span x-text="showAllTypes ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ $typesList->count() }}'"></span>
                                    <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllTypes }">
                                        <x-icon-down-arrow-outline />
                                    </span>
                                </a>
                            </div>
                        @endif
                    </div>
                </div>

                {{-- Category & Subcategory --}}
                <div class="py-6 border-b border-solid border-gray-1600">
                    <a href="javascript:void(0)"
                        @click="openCategory = !openCategory"
                        class="flex justify-between items-center collapse-btn">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                            {{ __('Category & Subcategory') }}
                        </h4>
                        <span class="flex justify-center items-center w-5 h-5">
                            <x-icon-down-arrow-outline />
                        </span>
                    </a>
                    <div class="mt-3 filter-collapse filter-widget"
                        x-show="openCategory"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0">
                        <div class="mb-4">
                            <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                {{ __('Main Category') }}
                            </h4>
                            <div class="relative mt-1">
                                <select wire:model.live.debounce.500ms="category" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                    <option value="">{{ __('All main category') }}</option>
                                    @foreach ($mainCategoriesList as $mainCategory)
                                        <option value="{{ $mainCategory->slug }}">{{ $mainCategory->classified_category_name }}</option>
                                    @endforeach
                                </select>
                                <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2">
                                    <x-icon-down-arrow-outline />
                                </span>
                            </div>
                        </div>
                        @if (!empty($category))
                            @if ($subCategoriesList)
                                <div class="{{ $subCategoriesList->count() > 0 ? 'block' : 'hidden' }}">
                                    <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                        {{ __('Subcategory') }}
                                    </h4>
                                    <div class="relative mt-1">
                                        <select wire:model.live.debounce.500ms="subCategory" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                            <option value="">{{ __('All subcategory') }}</option>
                                            @foreach ($subCategoriesList as $subCategory)
                                                <option value="{{ $subCategory->slug }}">{{ $subCategory->classified_category_name }}</option>
                                            @endforeach
                                        </select>
                                        <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2">
                                            <x-icon-down-arrow-outline />
                                        </span>
                                    </div>
                                </div>
                            @endif
                        @endif
                    </div>
                </div>

                {{-- Condition --}}
                @if (!empty($conditionsList))
                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            @click="openCondition = !openCondition"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                {{ __('Condition') }}
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget"
                            x-show="openCondition"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            <ul>
                                @foreach ($conditionsList->take(5) as $condition)
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="condition-{{ $condition->value }}"
                                                type="checkbox"
                                                value="{{ $condition->value }}"
                                                wire:model.live="condition"
                                                class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="condition-{{ $condition->value }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ $condition->getLabel() }}</label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>

                            @if ($conditionsList->count() > 5)
                                <div x-data="{ showAllConditions: false }">
                                    <div x-show="showAllConditions"
                                        x-transition:enter="transition duration-300 ease-in-out"
                                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                                        x-transition:enter-end="opacity-100 transform translate-y-0">
                                        <ul>
                                            @foreach ($conditionsList->skip(5) as $condition)
                                                <li>
                                                    <div class="flex items-center mb-2">
                                                        <input id="condition-{{ $condition->value }}"
                                                            type="checkbox"
                                                            value="{{ $condition->value }}"
                                                            wire:model.live="condition"
                                                            class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                        <label for="condition-{{ $condition->value }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">{{ $condition->getLabel() }}</label>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>

                                    <a @click="showAllConditions = !showAllConditions" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                        <span x-text="showAllConditions ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($conditionsList) }}'"></span>
                                        <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllConditions }">
                                            <x-icon-down-arrow-outline />
                                        </span>
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif

                {{-- Item Age --}}
                <div class="py-6 border-b border-solid border-gray-1600">
                    <a href="javascript:void(0)"
                        @click="openItemAge = !openItemAge"
                        class="flex justify-between items-center collapse-btn">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                            {{ __('Item Age') }}
                        </h4>
                        <span class="flex justify-center items-center w-5 h-5">
                            <x-icon-down-arrow-outline />
                        </span>
                    </a>
                    <div class="mt-3 filter-collapse filter-widget"
                        x-show="openItemAge"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0">
                        @if (!empty($itemAgeList))
                            <ul>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="any"
                                            type="radio"
                                            value=""
                                            wire:model.live="itemAge"
                                            class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="any" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                            {{ __('Any') }}
                                        </label>
                                    </div>
                                </li>
                                @foreach ($itemAgeList as $itemAge)
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="{{ $itemAge['value'] }}"
                                                type="radio"
                                                value="{{ $itemAge['value'] }}"
                                                wire:model.live="itemAge"
                                                class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="{{ $itemAge['value'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                {{ $itemAge['name'] }}
                                            </label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                    </div>
                </div>

                {{-- Pricing --}}
                {{-- <div class="py-6 border-b border-solid border-gray-1600">
                    <a href="javascript:void(0)"
                        @click="openPricing = !openPricing"
                        class="flex justify-between items-center collapse-btn">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Pricing') }}</h4>
                        <span class="flex justify-center items-center w-5 h-5">
                            <x-icon-down-arrow-outline />
                        </span>
                    </a>
                    <div class="mt-3 filter-collapse filter-widget"
                        x-show="openPricing"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0">
                        <ul>
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="default-checkbox27"
                                        type="checkbox"
                                        value=""
                                        checked=""
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="default-checkbox27" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Open
                                        Now <span class="text-xs leading-4 text-mid-gray">540</span></label>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="default-checkbox28"
                                        type="checkbox"
                                        value=""
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="default-checkbox28" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Verified
                                        Only <span class="text-xs leading-4 text-mid-gray">326</span></label>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="default-checkbox29"
                                        type="checkbox"
                                        value=""
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="default-checkbox29" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">With
                                        Customer Reviews <span class="text-xs leading-4 text-mid-gray">326</span></label>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="default-checkbox30"
                                        type="checkbox"
                                        value=""
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="default-checkbox30" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Emergency
                                        (24/7) <span class="text-xs leading-4 text-mid-gray">326</span></label>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center">
                                    <input id="default-checkbox31"
                                        type="checkbox"
                                        value=""
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="default-checkbox31" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">5
                                        stars <span class="text-xs leading-4 text-mid-gray">87</span></label>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div> --}}

                {{-- Flash Sale --}}
                @if (!empty($flashFilterList))
                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            @click="openFlashSale = !openFlashSale"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                {{ __('Flash Sale') }}
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget"
                            x-show="openFlashSale"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            @if (!empty($flashFilterList))
                                <ul>
                                    @foreach ($flashFilterList->take(5) as $flashFilter)
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="{{ $flashFilter['id'] }}"
                                                    type="checkbox"
                                                    value="{{ $flashFilter['id'] }}"
                                                    wire:model.live="flashFilter"
                                                    class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="{{ $flashFilter['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                    {{ $flashFilter['name'] }}
                                                </label>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                                @if ($flashFilterList->count() > 5)
                                    <div x-data="{ showAllFlashFilters: false }">
                                        <div x-show="showAllFlashFilters"
                                            x-transition:enter="transition duration-300 ease-in-out"
                                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                                            x-transition:enter-end="opacity-100 transform translate-y-0">
                                            <ul>
                                                @foreach ($flashFilterList->skip(5) as $flashFilter)
                                                    <li>
                                                        <div class="flex items-center mb-2">
                                                            <input id="{{ $flashFilter['id'] }}"
                                                                type="checkbox"
                                                                value="{{ $flashFilter['id'] }}"
                                                                wire:model.live="flashFilter"
                                                                class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                            <label for="{{ $flashFilter['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                                {{ $flashFilter['name'] }}
                                                            </label>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>

                                        <a @click="showAllFlashFilters = !showAllFlashFilters" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                            <span x-text="showAllFlashFilters ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($flashFilterList) }}'"></span>
                                            <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllFlashFilters }">
                                                <x-icon-down-arrow-outline />
                                            </span>
                                        </a>
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                @endif

                {{-- Seller Type --}}
                @if (!empty($sellerTypeList))
                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            class="flex justify-between items-center collapse-btn"
                            @click="openSellerType = !openSellerType">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Seller Type') }}</h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget"
                            x-show="openSellerType"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            @if (!empty($sellerTypeList))
                                <ul>
                                    @foreach ($sellerTypeList as $sellerType)
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="{{ $sellerType->value }}"
                                                    type="checkbox"
                                                    value="{{ $sellerType->value }}"
                                                    wire:model.live="sellerType"
                                                    class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="{{ $sellerType->value }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                    {{ $sellerType->getLabel() }}
                                                </label>
                                            </div>
                                        </li>
                                    @endforeach

                                </ul>
                            @endif
                        </div>
                    </div>
                @endif

                {{-- Date Posted --}}
                @if (!empty($datePostedList))
                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            class="flex justify-between items-center collapse-btn"
                            @click="openDatePosted = !openDatePosted">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Date Posted') }}</h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget"
                            x-show="openDatePosted"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            @if (!empty($datePostedList))
                                <ul>
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="any"
                                                type="radio"
                                                value=""
                                                wire:model.live="datePosted"
                                                class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="any" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                {{ __('Any') }}
                                            </label>
                                        </div>
                                    </li>
                                    @foreach ($datePostedList as $datePosted)
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="{{ $datePosted['id'] }}"
                                                    type="radio"
                                                    value="{{ $datePosted['id'] }}"
                                                    wire:model.live="datePosted"
                                                    class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="{{ $datePosted['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                    {{ $datePosted['name'] }}
                                                </label>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    </div>
                @endif

                {{-- Transaction & Delivery --}}
                @if (!empty($deliveryList))
                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            class="flex justify-between items-center collapse-btn"
                            @click="openTransactionAndDelivery = !openTransactionAndDelivery">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                {{ __('Transaction & Delivery') }}
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse filter-widget"
                            x-show="openTransactionAndDelivery"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            <ul>

                                @foreach ($deliveryList->take(5) as $delivery)
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="default-checkbox{{ $delivery['slug'] }}"
                                                type="checkbox"
                                                value="{{ $delivery['slug'] }}"
                                                wire:model.live="delivery"
                                                class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="default-checkbox{{ $delivery['slug'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                {{ $delivery['name'] }}
                                            </label>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                            @if ($deliveryList->count() > 5)
                                <div x-data="{ showAllDelivery: false }">
                                    <div x-show="showAllDelivery"
                                        x-transition:enter="transition duration-300 ease-in-out"
                                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                                        x-transition:enter-end="opacity-100 transform translate-y-0">
                                        <ul>
                                            @foreach ($deliveryList->skip(5) as $delivery)
                                                <li>
                                                    <div class="flex items-center mb-2">
                                                        <input id="default-checkbox{{ $delivery['slug'] }}"
                                                            type="checkbox"
                                                            value="{{ $delivery['slug'] }}"
                                                            wire:model.live="delivery"
                                                            class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                        <label for="default-checkbox{{ $delivery['slug'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                            {{ $delivery['name'] }}
                                                        </label>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    <div class="mt-4">
                                        <a @click="showAllDelivery = !showAllDelivery" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                            <span x-text="showAllDelivery ? 'Show Less' : 'Show all'">{{ __('Show all') }} {{ $deliveryList->count() }}</span>
                                            <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllDelivery }">
                                                <x-icon-down-arrow-outline />
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
                {{-- <div class="pt-6" x-data="{ openAdvancedFilters: false }">
                    <a href="javascript:void(0)"
                        @click="openAdvancedFilters = !openAdvancedFilters"
                        class="flex justify-between items-center collapse-btn">
                        <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                            {{ __('Advanced Filters') }}
                        </h4>
                        <span class="flex justify-center items-center w-5 h-5">
                            <x-icon-down-arrow-outline />
                        </span>
                    </a>
                    <div class="mt-3 filter-collapse filter-widget"
                        x-show="openAdvancedFilters"
                        x-transition:enter="transition duration-300 ease-in-out"
                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                        x-transition:enter-end="opacity-100 transform translate-y-0">
                        <ul>
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="default-checkbox52"
                                        type="checkbox"
                                        value=""
                                        checked=""
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="default-checkbox52" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Trending
                                        Now</label>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center mb-2">
                                    <input id="default-checkbox53"
                                        type="checkbox"
                                        value=""
                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                    <label for="default-checkbox53" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">Recently
                                        Reduced Price</label>
                                </div>
                        </ul>
                    </div>
                </div> --}}
            </form>
        </div>
    </div>
    <div class="block absolute bottom-0 left-0 p-6 w-full bg-white border-t border-solid lg:hidden border-gray-1200">
        <a href="javascript:void(0)"
            @click="openFilter = false"
            class="primary-btn">{{ __('Show :count Results', ['count' => $totalRecords]) }}</a>
    </div>
</div>
