@props(['equipment', 'target' => '_self'])
<div class="flex flex-col p-6 bg-white rounded-2xl border border-solid transition-all duration-500 ease-in-out group hover:shadow-10xl border-gray-1200 shadow-7xl">
    <a href="{{ route('equipment.show', ['slug' => $equipment->slug]) }}" target="{{ $target }}">
        @if ($equipment->getFirstMediaUrl('featured_image'))
            <div class="flex flex-col items-center">
                <img src="{{ $equipment->getFirstMediaUrl('featured_image', 'thumb') }}"
                    alt="{{ $equipment->title }}"
                    class="rounded-xl w-full h-[166px] object-cover object-center" />
            </div>
        @endif
        <div class="pt-4">
            <div class="flex items-center mb-1.5 {{ $equipment->getEquipmentCategories(1)->isNotEmpty() ? 'justify-between' : 'justify-end' }}">
                @if ($equipment->getEquipmentCategories(1)->isNotEmpty())
                    <span class="tags !border-0">{{ ucfirst($equipment->getEquipmentCategories(1)->pluck('category_name')->first()) }}</span>
                @endif
                {{-- <a href="#"> --}}
                <span class="flex justify-center items-center opacity-0 transition-all duration-500 ease-in-out group-hover:opacity-100">
                    <x-icon-right-top-arrow />
                </span>
                {{-- </a> --}}
            </div>
            <h4 class="font-medium text-base leading-6 tracking-[-0.176px] text-black-1200">{{ str()->limit($equipment->title, 40) }}</h4>

            <p class="text-sm font-normal leading-5 tracking-[-0.096px] mt-1.5 text-mid-gray line-clamp-2">
                {!! tiptap_converter()->asText(str()->limit($equipment->description, 100)) !!}
            </p>
            @if ($equipment->getEquipmentFullAddress())
                <span class="text-mid-gray mt-3 font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2">
                    <span class="flex justify-center items-center w-5 h-5">
                        <x-icon-location-outline-v2 />
                    </span>
                    {{ $equipment->getEquipmentFullAddress('short') }}
                </span>
            @endif
        </div>
    </a>
</div>
