@props(['module', 'modelId', 'isFavorite' => false])
@php
    $action = $isFavorite ? 'remove_from_favourite' : 'add_to_favourite';
    $iconClass = $isFavorite ? 'text-red-500' : '';
    $buttonId = $action . '-' . $module . '-' . $modelId;
@endphp
<a href="javascript:void(0)"
    data-action="{{ $action }}"
    data-module="{{ $module }}"
    data-model-id="{{ $modelId }}"
    {{ $attributes->merge(['class' => 'overflow-hidden relative cursor-pointer ' . $iconClass]) }}
    :disabled="$store.actions.isLoading('{{ $buttonId }}')">

    <!-- Loading Overlay -->
    <x-frontend.includes.modal-element-loading class="action-loading-spinner rounded-md" />

    {{ $slot }}
</a>
