@props(['user'])
@php
    $modalId = uniqid('contact-modal-');
@endphp
<a href="javascript:void(0)"
    x-data="{}"
    data-contact-user="{{ $user->slug }}"
    x-on:click="
        Livewire.dispatch('openModal', { 
                component: 'frontend.member.modal.member-contact-modal',
                arguments: { member: '{{ $user->slug }}', modalId: '{{ $modalId }}' },
            });"
    {{ $attributes->merge(['class' => 'overflow-hidden relative cursor-pointer']) }}>

    <!-- Loading Overlay -->
    <x-frontend.includes.modal-element-loading :class="'contact-overlay-' . $user->slug" data-modal-id="{{ $modalId }} rounded-md" />

    {{ $slot }}
</a>
