@props([
    'rows' => 6,
    'layout' => 'simple-list',
])

<div {{ $attributes->merge(['class' => 'w-full space-y-6']) }}>
    @for ($i = 0; $i < $rows; $i++)
        @if ($layout == 'job-list')
            <div class="flex flex-col px-4 py-4 space-y-4 bg-white rounded-xl shadow-lg lg:flex-row lg:items-center lg:justify-between lg:px-6 lg:py-6 lg:space-y-0">
                <div class="flex flex-1 items-start space-x-3 lg:space-x-4">
                    <!-- Company Logo -->
                    <div class="flex-shrink-0 w-12 h-12 bg-gray-200 rounded-lg animate-pulse lg:w-16 lg:h-16"></div>

                    <div class="flex-1 min-w-0">
                        <!-- Job Title with Badge -->
                        <div class="flex flex-wrap items-start mb-2 space-x-2 lg:items-center lg:space-x-3">
                            <div class="w-48 h-6 bg-gray-200 rounded animate-pulse lg:w-72 lg:h-7"></div>
                            <div class="w-10 h-5 bg-gray-200 rounded-full animate-pulse lg:w-12 lg:h-6"></div>
                        </div>

                        <!-- Company Name -->
                        <div class="mb-3 w-40 h-4 bg-gray-200 rounded animate-pulse lg:w-48 lg:h-5"></div>

                        <!-- Job Details Row (Location, Type, Salary) -->
                        <div class="flex flex-col mb-3 space-y-2 lg:flex-row lg:items-center lg:space-y-0 lg:space-x-6">
                            <div class="flex items-center space-x-2">
                                <div class="w-3 h-3 bg-gray-200 rounded animate-pulse lg:w-4 lg:h-4"></div>
                                <div class="w-24 h-3 bg-gray-200 rounded animate-pulse lg:w-28 lg:h-4"></div>
                                <div class="w-16 h-3 bg-gray-200 rounded animate-pulse lg:w-20 lg:h-4"></div>
                            </div>
                        </div>

                        <!-- Salary and Tags Row -->
                        <div class="flex flex-col mb-3 space-y-2 lg:flex-row lg:items-center lg:space-y-0 lg:space-x-6">
                            <div class="w-28 h-3 bg-gray-200 rounded animate-pulse lg:w-36 lg:h-4"></div>
                            <div class="flex items-center space-x-3">
                                <div class="flex items-center space-x-1">
                                    <div class="w-3 h-3 bg-gray-200 rounded animate-pulse lg:w-4 lg:h-4"></div>
                                    <div class="w-10 h-3 bg-gray-200 rounded animate-pulse lg:w-12 lg:h-4"></div>
                                </div>
                                <div class="flex items-center space-x-1">
                                    <div class="w-3 h-3 bg-gray-200 rounded animate-pulse lg:w-4 lg:h-4"></div>
                                    <div class="w-12 h-3 bg-gray-200 rounded animate-pulse lg:w-16 lg:h-4"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Dates Row -->
                        <div class="flex flex-col space-y-1 sm:flex-row sm:items-center sm:space-y-0 sm:space-x-4 lg:space-x-6">
                            <div class="flex items-center space-x-1 lg:space-x-2">
                                <div class="w-3 h-3 bg-gray-200 rounded animate-pulse lg:w-4 lg:h-4"></div>
                                <div class="w-28 h-3 bg-gray-200 rounded animate-pulse lg:w-32 lg:h-4"></div>
                            </div>
                            <div class="flex items-center space-x-1 lg:space-x-2">
                                <div class="w-3 h-3 bg-gray-200 rounded animate-pulse lg:w-4 lg:h-4"></div>
                                <div class="w-28 h-3 bg-gray-200 rounded animate-pulse lg:w-32 lg:h-4"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col space-y-3 lg:ml-6 lg:flex-shrink-0">
                    <!-- Primary Action Button -->
                    <div class="w-full h-10 bg-gray-200 rounded-lg animate-pulse lg:w-36 lg:h-12"></div>

                    <!-- Secondary Actions (Save & Share) - Mobile Only -->
                    <div class="flex space-x-3 lg:hidden">
                        <div class="flex-1 h-10 bg-gray-200 rounded-lg animate-pulse"></div>
                        <div class="flex-1 h-10 bg-gray-200 rounded-lg animate-pulse"></div>
                    </div>
                </div>
            </div>
        @elseif ($layout == 'member-list')
            <div class="flex flex-col px-6 py-6 space-y-4 bg-white rounded-xl shadow-lg">
                <div class="flex items-start space-x-6">
                    <!-- Logo/avatar -->
                    <div class="w-24 h-24 bg-gray-200 rounded-lg animate-pulse"></div>
                    <div class="flex-1">
                        <!-- Name and badge -->
                        <div class="flex items-center mb-2 space-x-3">
                            <div class="w-40 h-6 bg-gray-200 rounded animate-pulse"></div>
                            <div class="w-14 h-6 bg-gray-200 rounded-full animate-pulse"></div>
                        </div>
                        <!-- Tags/links -->
                        <div class="flex mb-2 space-x-3">
                            <div class="w-24 h-4 bg-gray-200 rounded animate-pulse"></div>
                            <div class="w-28 h-4 bg-gray-200 rounded animate-pulse"></div>
                        </div>
                        <!-- Location, rating, reviews -->
                        <div class="flex items-center mb-2 space-x-3">
                            <div class="w-40 h-4 bg-gray-200 rounded animate-pulse"></div>
                            <div class="w-10 h-5 bg-gray-200 rounded animate-pulse"></div>
                            <div class="w-20 h-4 bg-gray-200 rounded animate-pulse"></div>
                        </div>
                    </div>
                </div>
                <!-- Divider -->
                <div class="my-2 border-t border-gray-200"></div>
                <!-- Action buttons row -->
                <div class="flex justify-between items-center">
                    <div class="flex space-x-4">
                        <div class="w-24 h-10 bg-gray-200 rounded-lg animate-pulse"></div>
                        <div class="w-24 h-10 bg-gray-200 rounded-lg animate-pulse"></div>
                        <div class="w-24 h-10 bg-gray-200 rounded-lg animate-pulse"></div>
                    </div>
                    <div class="w-20 h-10 bg-gray-200 rounded-lg animate-pulse"></div>
                </div>
            </div>
        @elseif ($layout == 'classified-list')
            <div class="bg-white rounded-xl shadow-sm overflow-hidden animate-pulse">
                <!-- Mobile Layout (Vertical) -->
                <div class="block md:hidden">
                    <!-- Mobile Image placeholder -->
                    <div class="w-full h-48 bg-gray-200"></div>
                    
                    <!-- Mobile Content -->
                    <div class="p-4">
                        <!-- Title -->
                        <div class="w-4/5 h-6 bg-gray-200 rounded mb-3"></div>
                        
                        <!-- Price -->
                        <div class="w-24 h-8 bg-gray-200 rounded mb-4"></div>
                        
                        <!-- Status badges -->
                        <div class="flex items-center space-x-2 mb-4">
                            <div class="w-12 h-6 bg-gray-200 rounded-full"></div>
                            <div class="w-20 h-6 bg-gray-200 rounded-full"></div>
                            <div class="w-16 h-6 bg-gray-200 rounded-full"></div>
                        </div>
                        
                        <!-- Location and date -->
                        <div class="flex items-center justify-between mb-4">
                            <div class="flex items-center space-x-1">
                                <div class="w-3 h-3 bg-gray-200 rounded"></div>
                                <div class="w-28 h-4 bg-gray-200 rounded"></div>
                            </div>
                            <div class="flex items-center space-x-1">
                                <div class="w-3 h-3 bg-gray-200 rounded"></div>
                                <div class="w-24 h-4 bg-gray-200 rounded"></div>
                            </div>
                        </div>
                        
                        <!-- Mobile Action buttons -->
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-2">
                                <div class="w-10 h-10 bg-gray-200 rounded-full"></div>
                                <div class="w-10 h-10 bg-gray-200 rounded-full"></div>
                            </div>
                        </div>
                        
                        <!-- Mobile View Listing button -->
                        <div class="w-full h-12 bg-gray-200 rounded-lg mt-4"></div>
                    </div>
                </div>
                
                <!-- Desktop Layout (Horizontal) -->
                <div class="hidden md:flex">
                    <!-- Desktop Image placeholder -->
                    <div class="flex-shrink-0 w-40 h-40 bg-gray-200"></div>
                    
                    <!-- Desktop Content area -->
                    <div class="flex-1 p-4 flex flex-col justify-between">
                        <div class="flex-1">
                            <!-- Title -->
                            <div class="w-4/5 h-7 bg-gray-200 rounded mb-3"></div>
                            
                            <!-- Price -->
                            <div class="w-28 h-9 bg-gray-200 rounded mb-3"></div>
                            
                            <!-- Status badge and category -->
                            <div class="flex items-center space-x-3 mb-3">
                                <div class="w-12 h-5 bg-gray-200 rounded-full"></div>
                                <div class="w-20 h-4 bg-gray-200 rounded"></div>
                            </div>
                            
                            <!-- Location and date info -->
                            <div class="flex items-center space-x-4">
                                <div class="flex items-center space-x-1">
                                    <div class="w-4 h-4 bg-gray-200 rounded"></div>
                                    <div class="w-28 h-4 bg-gray-200 rounded"></div>
                                </div>
                                <div class="flex items-center space-x-1">
                                    <div class="w-4 h-4 bg-gray-200 rounded"></div>
                                    <div class="w-24 h-4 bg-gray-200 rounded"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Desktop Action buttons -->
                    <div class="flex flex-col justify-between p-4">
                        <div class="flex items-start space-x-2">
                            <div class="w-8 h-8 bg-gray-200 rounded animate-pulse"></div>
                            <div class="w-8 h-8 bg-gray-200 rounded animate-pulse"></div>
                        </div>
                        <div class="w-24 h-10 bg-gray-200 rounded-lg animate-pulse"></div>
                    </div>
                </div>
            </div>
        @elseif ($layout == 'article-list')
            <div class="overflow-hidden w-full bg-white rounded-xl shadow-md animate-pulse">
                <div class="flex flex-col w-full md:flex-row">
                    <!-- Taller image placeholder -->
                    <div class="flex-none h-64 bg-gray-200 md:h-auto md:w-[25rem]"></div>

                    <!-- Text placeholders -->
                    <div class="flex-1 p-6 space-y-6">
                        <div class="w-4/5 h-8 bg-gray-200 rounded"></div>
                        <div class="w-3/5 h-6 bg-gray-200 rounded"></div>
                        <div class="w-full h-6 bg-gray-200 rounded"></div>
                        <div class="w-11/12 h-6 bg-gray-200 rounded"></div>

                        <!-- Button placeholders -->
                        <div class="flex pt-6 space-x-4">
                            <div class="flex-1 h-12 bg-gray-200 rounded"></div>
                            <div class="flex-1 h-12 bg-gray-200 rounded"></div>
                        </div>
                    </div>
                </div>
            </div>
        @elseif ($layout == 'article-grid')
            <div class="grid grid-cols-2 gap-6">
                @for ($j = 0; $j < 2; $j++)
                    <div class="overflow-hidden w-full bg-white rounded-xl shadow-md animate-pulse">
                        <!-- Image placeholder -->
                        <div class="w-full h-48 bg-gray-200"></div>
                        
                        <!-- Content area -->
                        <div class="p-4 space-y-4">
                            <!-- Title placeholder -->
                            <div class="w-3/4 h-6 bg-gray-200 rounded"></div>
                            
                            <!-- Description placeholders -->
                            <div class="space-y-2">
                                <div class="w-full h-4 bg-gray-200 rounded"></div>
                                <div class="w-5/6 h-4 bg-gray-200 rounded"></div>
                            </div>

                            <!-- Meta info placeholders -->
                            <div class="flex items-center justify-between pt-2">
                                <div class="w-24 h-4 bg-gray-200 rounded"></div>
                                <div class="w-16 h-4 bg-gray-200 rounded"></div>
                            </div>
                        </div>
                    </div>
                @endfor
            </div>
        @elseif ($layout == 'review-list')


            
        @else
            <!-- Simple List Item -->
            <div class="flex justify-between items-center px-5 py-4 bg-white rounded-lg shadow-sm">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 bg-gray-200 rounded-full animate-pulse"></div>
                    <div class="space-y-2">
                        <div class="w-48 h-4 bg-gray-200 rounded animate-pulse"></div>
                        <div class="w-32 h-3 bg-gray-200 rounded animate-pulse"></div>
                    </div>
                </div>
                <div class="flex items-center space-x-2">
                    <div class="w-8 h-8 bg-gray-200 rounded animate-pulse"></div>
                    <div class="w-8 h-8 bg-gray-200 rounded animate-pulse"></div>
                </div>
            </div>
        @endif
    @endfor
</div>
