@props([
    /** Alpine.js state property to toggle open/closed, e.g. "openLocation" (optional if not collapsible) */
    'openVar' => null,
    /** Section title */
    'title',
    /** Enable or disable collapse behavior */
    'collapsible' => false,
    /** Class for the section */
    'class' => '',
])


<div class="{{ $class }}">
    {{-- Header --}}
    @if ($collapsible)
        <h4 class="text-primary-blue
            mb-2 
            xl:text-lg text-[15px]
            font-bold leading-[130%]
            flex items-center justify-between
            cursor-pointer
            mb-2
            " x-on:click="{{ $openVar }} = !{{ $openVar }}">
            {{ $title }}
            <button class="flex items-center justify-center w-[22px] h-[22px]" type="button">
                <svg :class="{{ $openVar }} ? 'xl:rotate-[-90deg] rotate-[0deg]' : 'rotate-[-90deg] xl:rotate-[-90deg]'" class="w-1.5 h-2.5 text-gray-1500 mx-1" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4" />
                </svg>
            </button>

        </h4>
    @else
        <h4 class="text-primary-blue xl:text-lg text-[15px] font-bold leading-[130%] mb-2">
            {{ $title }}
        </h4>
    @endif
    @if (isset($selectedFilters))
        {{ $selectedFilters }}
    @endif
    {{-- Content wrapper --}}
    @if ($collapsible)
        <div class="filter-widget xl:mt-3" :class="{ 'active': {{ $openVar }} }">
        @else
            <div class="">
    @endif
    {{-- Mobile back header (only if collapsible) --}}
    @if ($collapsible)
        <div class="bg-primary-blue z-30 px-4 py-[18px] flex items-center gap-3 xl:hidden">
            <button class="back-btn flex items-center w-4 h-4" x-on:click.prevent="{{ $openVar }} = false; $event.stopPropagation()">
                <x-icon-arrow-back class="w-4 h-4 text-white" />
            </button>
            <h4 class="text-white text-base font-bold leading-[130%]">{{ __('Back') }}</h4>
        </div>

        {{-- Main slot area --}}
        <div class="xl:px-0 px-4 xl:py-0 py-5 xl:h-auto xl:overflow-y-hidden overflow-y-auto h-[calc(100vh_-_129px)]">
            <h4 class="text-primary-blue xl:hidden text-base font-bold leading-[130%] mb-3 flex items-center justify-between">
                {{ $title }}
            </h4>
            {{ $slot }}
        </div>
    @else
        {{ $slot }}
    @endif

    {{-- Mobile apply & back footer (only if collapsible) --}}
    @if ($collapsible)
        <div class="p-4 xl:hidden block">
            <a href="#" class="back-btn text-[13px] font-bold leading-5 text-white rounded-lg bg-primary-blue flex items-center justify-center h-10 gap-3" x-on:click.prevent="{{ $openVar }} = false; $event.stopPropagation()">
                <x-icon-arrow-back />
                {{ __('Apply & Back') }}
            </a>
        </div>
    @endif
</div>
</div>
