@props(['url' => null, 'platform' => 'facebook', 'page' => 'article'])
@php
    $currentUrl = $url ?? request()->url();
    $shareText = __('Check out this :page on :site', ['page' => $page, 'site' => config('app.name')]);
    $encodedUrl = urlencode($currentUrl);
    $encodedText = urlencode($shareText);

    if ($platform == 'facebook') {
        $url = "https://www.facebook.com/sharer/sharer.php?u={$encodedUrl}";
    } elseif ($platform == 'twitter') {
        $url = "https://twitter.com/intent/tweet?url={$encodedUrl}&text={$encodedText}";
    } elseif ($platform == 'linkedin') {
        $url = "https://www.linkedin.com/shareArticle?mini=true&url={$encodedUrl}&title={$encodedText}";
    } elseif ($platform == 'instagram') {
        $url = "https://www.instagram.com/share?url={$encodedUrl}";
    } elseif ($platform == 'email') {
        $url = "mailto:?subject={$shareText}&body={$encodedUrl}";
    }
@endphp
<a href="{{ $url }}"
    {{ $attributes->merge(['class' => '']) }}
    target="_blank"
    rel="noopener noreferrer">
    {{ $slot }}
</a>
