<!-- Main modal -->
<div id="share-modal"
    tabindex="-1"
    aria-hidden="true"
    class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[1000] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">

    <!-- Dark backdrop overlay -->
    <div class="modal-backdrop" data-modal-hide="share-modal"></div>
    <div class="relative p-4 w-full max-w-[608px] max-h-full z-10">
        <!-- Modal content -->
        <div class="relative bg-white rounded-xl shadow-xl">
            <button type="button"
                class="cursor-pointer absolute top-3 right-3 text-[#525866] hover:text-[#0E121B] p-1.5 rounded-lg hover:bg-[#F5F7F9] transition-colors duration-200 z-10"
                data-modal-hide="share-modal">
                <x-icon-close-icon />
            </button>
            <div class="p-6">
                <div class="text-center">
                    <h2 class="text-primary-blue font-bold text-[32px] leading-[130%] mb-2.5">{{ __('Share this Profile') }}</h2>
                    <p class="text-gray-1500 font-normal text-[15px]">{{ __('Share this profile with your network') }}</p>
                </div>
                <div class="mt-8 text-center">
                    <h4 class="text-primary-blue font-bold text-xl mb-4 leading-[130%]">{{ __('Social Share Options') }}</h4>
                    <ul class="flex gap-4 justify-center items-center mt-4">
                        <li>
                            <a href="#"
                                class="flex justify-center items-center w-12 h-12 rounded-lg transition-all duration-500 ease-in-out social-share-btn group bg-gray-1400 hover:bg-primary-blue"
                                data-platform="facebook">
                                <x-icon-facebook-outline class="group-hover:brightness-[1000%] h-[18px]" />
                            </a>
                        </li>
                        <li>
                            <a href="#"
                                class="flex justify-center items-center w-12 h-12 rounded-lg transition-all duration-500 ease-in-out social-share-btn group bg-gray-1400 hover:bg-primary-blue"
                                data-platform="twitter">
                                <x-icon-twitter-outline class="group-hover:brightness-[1000%] h-[18px]" />
                            </a>
                        </li>
                        <li>
                            <a href="#"
                                class="flex justify-center items-center w-12 h-12 rounded-lg transition-all duration-500 ease-in-out social-share-btn group bg-gray-1400 hover:bg-primary-blue"
                                data-platform="linkedin">
                                <x-icon-linked-outline class="group-hover:brightness-[1000%] h-[17px]" />
                            </a>
                        </li>
                        <li>
                            <a href="#"
                                class="flex justify-center items-center w-12 h-12 rounded-lg transition-all duration-500 ease-in-out social-share-btn group bg-gray-1400 hover:bg-primary-blue"
                                data-platform="instagram">
                                <x-icon-instagram-outline class="group-hover:brightness-[1000%] h-5" />
                            </a>
                        </li>
                        <li>
                            <a href="#"
                                class="flex justify-center items-center w-12 h-12 rounded-lg transition-all duration-500 ease-in-out social-share-btn group bg-gray-1400 hover:bg-primary-blue"
                                data-platform="email">
                                <x-icon-email-outline class="group-hover:brightness-[1000%] h-[18px]" />
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="mt-8">
                    <span class="text-primary-blue font-bold text-[15px] leading-5 block mb-3">{{ __('Copy Link') }}</span>
                    <div id="copy-text" class="flex overflow-hidden items-stretch rounded-xl border border-solid border-primary-blue">
                        <p id="text" class="text-[17px] flex items-center line-clamp-1 font-normal leading-5 flex-1 text-gray-1500 bg-white px-5 py-3">
                            {{ '' }}
                        </p>
                        <button id="copy" class="text-white text-base leading-6 font-extrabold flex items-center justify-center bg-black hover:bg-gray-800 transition-colors duration-200 px-6 min-w-[100px]">
                            {{ __('Copy') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
