@php
    $currentUrl = request()->url();
    $shareText = $user ? "Check out {$user->name}'s profile" : 'Check out this profile';
    $encodedUrl = urlencode($currentUrl);
    $encodedText = urlencode($shareText);
@endphp
{{-- border-t border-solid border-gray-1200 --}}
<div {{ $attributes->merge(['class' => 'pt-12']) }}>
    <h6>{{ __('Social Profiles') }}</h6>
    <ul class="flex items-center gap-3 mt-5">
        @if (!empty($user->facebook_url))
            <li>
                <a href="https://www.facebook.com/sharer/sharer.php?u={{ $encodedUrl }}"
                    target="_blank"
                    rel="noopener noreferrer"
                    class="bg-gray-1400 w-10 h-10 flex items-center justify-center rounded-full">
                    <x-icon-facebook />
                </a>
            </li>
        @endif
        @if (!empty($user->twitter_url))
            <li>
                <a href="https://twitter.com/intent/tweet?url={{ $encodedUrl }}&text={{ $encodedText }}"
                    target="_blank"
                    rel="noopener noreferrer"
                    class="bg-gray-1400 w-10 h-10 flex items-center justify-center rounded-full">
                    <x-icon-twitter-x />
                </a>
            </li>
        @endif
        @if (!empty($user->linkedin_url))
            <li>
                <a href="https://www.linkedin.com/sharing/share-offsite/?url={{ $encodedUrl }}"
                    target="_blank"
                    rel="noopener noreferrer"
                    class="bg-gray-1400 w-10 h-10 flex items-center justify-center rounded-full">
                    <x-icon-linkedin />
                </a>
            </li>
        @endif
        @if (!empty($user->instagram_url))
            <li>
                <button onclick="copyProfileLinkToClipboard('{{ $currentUrl }}')"
                    title="Copy link to share on Instagram"
                    class="bg-gray-1400 w-10 h-10 flex items-center justify-center rounded-full">
                    <x-icon-instagram />
                </button>
            </li>
        @endif
        @if (!empty($user->email))
            <li>
                <a href="mailto:?subject={{ urlencode($shareText) }}&body={{ urlencode($shareText . ' - ' . $currentUrl) }}" class="bg-gray-1400 w-10 h-10 flex items-center justify-center rounded-full">
                    <x-icon-link />
                </a>
            </li>
        @endif
    </ul>
</div>
