@props(['sort' => 'created-desc', 'sortText', 'component'])
<div class="relative hidden lg:block">
    <button id="openSortDropdown" data-dropdown-toggle="dropdown" class="border border-solid border-gray-1200 rounded-full shadow-3xl h-10 inline-flex cursor-pointer items-center justify-center gap-2.5 pr-2.5 pl-3 text-black-1200 text-sm font-normal leading-6 tracking-[-0.096px]" type="button">
        <x-icon-sort-icon />
        {{ __('Sort by') }}: {{ $sortText }}
        <span class="flex justify-center items-center w-5 h-5">
            <x-icon-arrow-down-light />
        </span>
    </button>

    <!-- Desktop Dropdown menu -->
    <div id="dropdown" class="z-[100] hidden bg-white rounded-3xl shadow-12xl w-[280px]">
        <div class="py-[18px] px-6 border-b border-solid border-gray-1200">
            <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">
                {{ __('Sort by') }}
            </h4>
        </div>

        <!-- Sort Options Content -->
        <div class="p-6">
            <x-dynamic-component 
                :component="$component ?? 'frontend.member.listing.partials.member-sort-dropdown'"
                type="desktop"
                :sort="$sort"
            />

            <!-- Save Button -->
            <div>
                <button type="button" wire:click="applySortOrder()" onclick="document.getElementById('openSortDropdown').click();" class="cursor-pointer text-sm font-medium leading-5 tracking-[-0.096px] text-white flex items-center justify-center bg-black-1200 rounded-full lg:h-10 md:h-8 h-10 w-full">
                    {{ __('Save') }}
                </button>
            </div>
        </div>
    </div>
</div>
