@props(['sort' => 'created-desc', 'component' => 'frontend.member.listing.partials.member-sort-dropdown'])

<dialog x-ref="mobileSortModal" class="lg:hidden backdrop:bg-black/50 backdrop:backdrop-blur-sm rounded-3xl w-auto mx-4 my-auto p-0 border-0 max-h-[80vh] overflow-hidden">
    <div class="overflow-y-auto max-h-full bg-white rounded-3xl">
        <!-- Mobile Modal Header -->
        <div class="flex justify-between items-center px-6 py-4 border-b border-solid border-gray-1200">
            <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">
                {{ __('Sort by') }}
            </h4>
            <button type="button" @click="$refs.mobileSortModal.close()" class="text-gray-400 hover:text-gray-600">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>

        <!-- Sort Options Content -->
        <div class="p-6">
            <x-dynamic-component 
                :component="$component ?? 'frontend.member.listing.partials.member-sort-dropdown'"
                type="mobile"
                :sort="$sort"
            />

            <!-- Save Button -->
            <div class="mt-6">
                <button type="button" wire:click="applySortOrder()" @click="$refs.mobileSortModal.close(); document.body.style.overflow = 'auto';" class="cursor-pointer text-sm font-medium leading-5 tracking-[-0.096px] text-white flex items-center justify-center bg-black-1200 rounded-full h-10 w-full">
                    {{ __('Save') }}
                </button>
            </div>
        </div>
    </div>
</dialog>
