@props(['job', 'target' => '_self'])
<div class="relative p-6 mb-6 bg-white rounded-2xl border border-solid transition-all duration-500 ease-in-out cursor-pointer hover:shadow-10xl border-gray-1200 xl:p-6 md:p-4">

    <div class="flex flex-col xl:gap-6 md:gap-3.5 md:flex-row">
        <div class="md:max-w-[100px] max-w-[72px] w-full md:h-[100px] h-[72px] rounded-2xl border border-solid border-gray-1200 relative">
            @include('components.frontend.job.partials.job-card.job-card-logo')
        </div>
        <div class="flex-1 w-full">
            <div class="mt-6 md:mt-0">
                <a href="{{ route('job.show', ['slug' => $job->slug]) }}"
                    target="{{ $target }}"
                    >
                    <h4 class="xl:text-[32px] text-2xl font-medium md:leading-10 leading-7 tracking-[-0.08px] text-black-1200 flex md:flex-row flex-col-reverse md:items-center items-start gap-3">
                        {{ $job->job_title }} <span class="feature-tag">{{ __('Featured') }}</span>
                        @include('components.frontend.job.partials.job-card.applied-label')
                    </h4>
                </a>
                <h5 class="mt-0.5 text-base font-medium leading-7 text-black-1200 md:text-xl">
                    @include('components.frontend.job.partials.job-card.job-author')
                </h5>
                <ul class="flex flex-wrap gap-1.5 items-center mt-1 sm:gap-2">
                    @include('components.frontend.job.partials.job-card.address-row')
                </ul>
            </div>
        </div>
    </div>
    <div class="mt-6">
        @if ($job->jobTypeName() || $job->saleryRange() || $job->jobCarerLevel() || $job->jobIndustry() || $job->jobRole())
            <ul class="flex flex-wrap gap-2 items-center">
                @if ($job->jobTypeName())
                    <li><a href="#" class="tags !border-0">{{ $job->jobTypeName() }}</a></li>
                @endif
                @if ($job->workMode())
                    <li><a href="#" class="tags !border-0">{{ $job->workMode() }}</a></li>
                @endif
                @if ($job->saleryRange())
                    <li><a href="#" class="tags !border-0">{{ $job->saleryRange() }}</a></li>
                @endif
                @if ($job->jobCarerLevel())
                    <li><a href="#" class="tags !border-0">{{ $job->jobCarerLevel() }}</a></li>
                @endif
                @if ($job->jobIndustry())
                    <li><a href="#" class="tags !border-0">{{ $job->jobIndustry() }}</a></li>
                @endif
                @if ($job->jobRole())
                    <li><a href="#" class="tags !border-0">{{ $job->jobRole() }}</a></li>
                @endif
            </ul>
        @endif
        <ul class="grid grid-cols-2 gap-3 mt-6 md:grid-cols-4">
            @if ($job->author?->profile?->phone)
                <li>
                    <a href="tel:{{ $job->author->profile->phone }}" class="group w-full text-mid-gray hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                        <x-icon-phone-outline />
                        {{ __('Call Now') }}
                    </a>
                </li>
            @endif
            @if ($job->author?->email)
                <li>
                    <x-frontend.includes.contact-modal-button :user="$job->author" class="group w-full text-mid-gray hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                        <x-icon-message-circle-outline />
                        {{ __('Message us') }}
                    </x-frontend.includes.contact-modal-button>
                </li>
            @endif
            <li>
                <a href="{{ $job->permalink }}" class="secondary-btn"
                    target="{{ $target }}"
                    >
                    <x-icon-right-arrow-top />
                    {{ __('View Job') }}
                </a>
            </li>
        </ul>
    </div>
</div>
