@props(['job', 'target' => '_self'])
<div class="flex relative flex-col gap-4 p-6 mb-6 bg-white rounded-2xl border border-solid xl:gap-4 md:gap-3.5 md:flex-row border-gray-1200 xl:p-6 md:p-4">
    <div class="md:max-w-[100px] max-w-[72px] w-full md:h-[100px] h-[72px] rounded-2xl border border-solid border-gray-1200 relative">
        @include('components.frontend.job.partials.job-card.job-card-logo')
    </div>
    <div class="flex flex-col flex-1 justify-between w-full">
        <div class="flex justify-between items-start">
            <div>
                <a href="{{ route('job.show', ['slug' => $job->slug]) }}"
                    target="{{ $target }}"
                    >
                    <h4 class="flex flex-col-reverse gap-3 items-start text-xl font-medium leading-7 xl:text-xl md:text-base text-black-1200 md:flex-row md:items-center">
                        {{ str()->limit($job->job_title, 30) }}
                        @if ($job->isNew())
                            <span class="status-Badge">{{ __('Newly Listed') }}</span>
                        @endif
                        @include('components.frontend.job.partials.job-card.applied-label')
                    </h4>
                </a>
                @if ($job->authorName())
                    <a href="{{ route('member.show', ['slug' => $job->author->slug]) }}">
                        <h5 class="text-black-1200 text-sm font-medium leading-5 tracking-[-0.096px] mt-1">
                            @include('components.frontend.job.partials.job-card.job-author')
                        </h5>
                    </a>
                @endif
                @if ($job->jobTypeName() || $job->saleryRange() || $job->jobCarerLevel() || $job->jobIndustry() || $job->jobRole())
                    <ul class="flex flex-wrap gap-2 items-center mt-3 sm:gap-0">
                        @if ($job->jobTypeName())
                            <li class="pr-2 text-xs font-medium leading-4 text-mid-gray">
                                {{ $job->jobTypeName() }}
                            </li>
                        @endif
                        @if ($job->workMode())
                            <li class="text-mid-gray font-medium text-xs leading-4 {{ $job->jobTypeName() ? 'border-l border-solid border-gray-1200 px-2' : '' }}">
                                {{ $job->workMode() }}
                            </li>
                        @endif
                        @if ($job->saleryRange())
                            <li class="text-mid-gray font-medium text-xs leading-4 {{ $job->jobTypeName() ? 'border-l border-solid border-gray-1200 px-2' : '' }}">
                                {{ $job->saleryRange() }}
                            </li>
                        @endif
                        @if ($job->jobCarerLevel())
                            <li class="text-mid-gray font-medium text-xs leading-4 {{ $job->saleryRange() ? 'border-l border-solid border-gray-1200 px-2' : '' }}">
                                {{ $job->jobCarerLevel() }}
                            </li>
                        @endif
                        @if ($job->jobIndustry())
                            <li class="text-mid-gray font-medium text-xs leading-4 {{ $job->jobCarerLevel() ? 'border-l border-solid border-gray-1200 px-2' : '' }}">
                                {{ $job->jobIndustry() }}</li>
                        @endif
                        @if ($job->jobRole())
                            <li class="text-mid-gray font-medium text-xs leading-4 {{ $job->jobIndustry() ? 'border-l border-solid border-gray-1200 px-2' : '' }}">
                                {{ $job->jobRole() }}
                            </li>
                        @endif
                    </ul>
                @endif
            </div>
            @include('components.frontend.job.partials.job-card.action-buttons')
        </div>
        <div class="flex justify-between items-center mt-3">
            <div>
                @if ($job->address() || $job->postedDate() || $job->deadlineDate())
                    <ul class="flex flex-wrap gap-1.5 items-center sm:gap-2">
                        @include('components.frontend.job.partials.job-card.address-row')
                    </ul>
                @endif
            </div>
            <a href="{{ route('job.show', ['slug' => $job->slug]) }}" class="secondary-btn md:w-[110px] w-full !h-9"
                target={{ $target }}
                >
                <x-icon-right-top-arrow />
                {{ __('View Job') }}
            </a>
        </div>
    </div>
</div>
