@props(['job', 'target' => '_self'])

<div class="bg-white border border-solid border-gray-1200 hover:shadow-26xl cursor-pointer transition-all duration-500 ease-in-out rounded-2xl md:p-6 p-4">
    <div class="border border-solid border-gray-1200 p-2.5 mb-4 rounded-2xl flex items-center justify-center flex-col w-[72px] h-[72px]">
        @include('components.frontend.job.partials.job-card.job-card-logo')
    </div>
    @if ($job->isNew())
        <span class="status-Badge">{{ __('Newly Listed') }}</span>
    @endif
    <h4 class="text-black-1200 md:text-xl text-base font-medium mt-3 leading-7 mb-1">
        {{ str()->limit($job->job_title, 30) }}
    </h4>
    @if ($job->authorName())
        @include('components.frontend.job.partials.job-card.job-author')
    @endif
    @if ($job->jobTypeName() || $job->saleryRange() || $job->jobCarerLevel() || $job->jobIndustry() || $job->jobRole())
        <ul class="flex flex-wrap items-center mt-3 gap-2">
            @if ($job->jobTypeName())
                <li class="text-xs font-medium leading-4 text-mid-gray">
                    {{ $job->jobTypeName() }}
                </li>
            @endif
            @if ($job->workMode())
                <li class="pl-2 text-xs font-medium leading-4 {{ $job->jobTypeName() ? 'border-l border-solid text-mid-gray border-gray-1200' : '' }}">
                    {{ $job->workMode() }}
                </li>
            @endif
            @if ($job->saleryRange())
                <li class="pl-2 text-xs font-medium leading-4 {{ $job->workMode() ? 'border-l border-solid text-mid-gray border-gray-1200' : '' }}">
                    {{ $job->saleryRange() }}
                </li>
            @endif
            @if ($job->jobCarerLevel())
                <li class="pl-2 text-xs font-medium leading-4 {{ $job->jobCarerLevel() ? 'border-l border-solid text-mid-gray border-gray-1200' : '' }}">
                    {{ $job->jobCarerLevel() }}
                </li>
            @endif
            @if ($job->jobIndustry())
                <li class="pl-2 text-xs font-medium leading-4 {{ $job->jobIndustry() ? 'border-l border-solid text-mid-gray border-gray-1200' : '' }}">
                    {{ $job->jobIndustry() }}
                </li>
            @endif
            @if ($job->jobRole())
                <li class="pl-2 text-xs font-medium leading-4 {{ $job->jobRole() ? 'border-l border-solid text-mid-gray border-gray-1200' : '' }}">
                    {{ $job->jobRole() }}
                </li>
            @endif
            {{-- <li class="pl-2 text-xs font-medium leading-4 border-l border-solid text-mid-gray border-gray-1200">
                Remote</li>
            <li class="pl-2 text-xs font-medium leading-4 border-l border-solid text-mid-gray border-gray-1200">
                $70k/yr - $90K/yr</li>
            <li class="pl-2 text-xs font-medium leading-4 border-l border-solid text-mid-gray border-gray-1200">
                Lead</li>
            <li class="pl-2 text-xs font-medium leading-4 border-l border-solid text-mid-gray border-gray-1200">
                Driller</li> --}}
        </ul>
    @endif
    @if ($job->address() || $job->postedDate() || $job->deadlineDate())
        <ul class="flex flex-wrap items-center gap-2 mt-3.5 mb-[26px]">
            @if ($job->address())
                <li class="text-mid-gray font-medium text-xs flex items-center gap-1">
                    <span class="flex justify-center items-center w-5 h-5">
                        <x-icon-location-outline-v2 />
                    </span>
                    {{ $job->address(1) }}
                </li>
            @endif
            @if ($job->postedDate())
                <li class="text-mid-gray font-medium text-xs flex items-center gap-1">
                    <span class="flex justify-center items-center w-5 h-5">
                        <x-icon-calendar-icon3 />
                    </span>
                    {{ __('Posted:') }} {{ $job->postedDate() }}
                </li>
            @endif
            @if ($job->deadlineDate())
                <li class="text-mid-gray font-medium text-xs flex items-center gap-1">
                    <span class="flex justify-center items-center w-5 h-5">
                        <x-icon-clock-icon />
                    </span>
                    {{ __('Deadline:') }} {{ $job->deadlineDate() }}
                </li>
            @endif
        </ul>
    @endif
    <a href="{{ route('job.show', ['slug' => $job->slug]) }}" class="secondary-btn secondary-btn-gradient w-full">
        <x-icon-right-top-arrow />
        {{ __('View Job') }}
    </a>
</div>
