<div class="py-12 border-b border-solid border-gray-1200">
    <div class="flex justify-between items-center">
        <h6>{{ __('Related Jobs') }}</h6>
        <a href="{{ route("job.index") }}" class="text-mid-gray hover:text-black-1200 w-[81px] font-medium text-sm leading-5 tracking-[-0.096px] flex items-center justify-center bg-gray-1400 hover:bg-white border border-solid border-gray-1400 hover:border-gray-1200 transition-all duration-500 ease-in-out rounded-full h-10">
            {{ __('View All') }}
        </a>
    </div>
    <div class="mt-5">
        @if ($relatedJobs->isNotEmpty())
            @foreach ($relatedJobs as $job)
                <x-frontend.job.job-card :job="$job" />
            @endforeach
        @else
            <x-frontend.includes.no-records-found-v1>
                <x-slot:icon>
                    <x-icon-search-icon />
                </x-slot:icon>
                <x-slot:title>
                    {{ __('Jobs') }}
                </x-slot:title>
                <x-slot:description>
                    {{ __('Jobs') }}
                </x-slot:description>
            </x-frontend.includes.no-records-found-v1>
        @endif
    </div>
</div>
