<div>
    <div class="bg-white border-solid lg:border border-gray-1200 lg:shadow-5xl lg:rounded-2xl">
        <div class="flex justify-between items-center px-6 pt-6 pb-3 border-b border-solid lg:pb-0 lg:border-0 border-gray-1200">
            <h6 class="hidden lg:block">
                {{ __('Filter by') }}
            </h6>
            <h6 class="flex gap-3 items-center lg:hidden">
                <x-icon-list-bars />
                {{ __('Filter') }}
                <span class="flex justify-center items-center w-6 h-6 text-xs font-medium text-white rounded-full bg-primary-blue">
                    @php
                        $filterCount = 0;
                        if (!empty($this->country)) {
                            $filterCount++;
                        }
                        if (!empty($this->state)) {
                            $filterCount++;
                        }
                        if (!empty($this->city)) {
                            $filterCount++;
                        }
                        if (!empty($this->work_mode)) {
                            $filterCount++;
                        }
                        if (!empty($this->job_type)) {
                            $filterCount++;
                        }
                        if (!empty($this->career_level)) {
                            $filterCount++;
                        }
                        if (!empty($this->job_industry)) {
                            $filterCount++;
                        }
                        if (!empty($this->job_type)) {
                            $filterCount++;
                        }
                        if (!empty($this->shift)) {
                            $filterCount++;
                        }
                        if (!empty($this->work_mode)) {
                            $filterCount++;
                        }
                        if (!empty($this->date_posted)) {
                            $filterCount++;
                        }
                    @endphp
                    {{ $filterCount }}
                </span>
            </h6>
            <div class="flex gap-3 items-center">
                <a href="javascript:void(0)"
                    x-on:click="$wire.resetFilters(); openFilter = false;"
                    class="flex text-primary-blue gap-2 items-center justify-center font-medium text-sm tracking-[-0.096px]">
                    <x-icon-close-icon class="hidden lg:block" /> {{ __('Clear all') }}
                </a>
                <a href="javascript:void(0)"
                    @click="openFilter = false"
                    class="flex justify-center items-center w-6 h-6 lg:hidden filter-close">
                    <x-icon-close-icon />
                </a>
            </div>
        </div>
        <div class="lg:px-px lg:h-auto lg:overflow-y-auto h-[calc(100vh_-_154px)] overflow-y-scroll">
            <div class="px-6 py-8 lg:py-6">
                <form wire:submit.prevent="applySearch">
                    <div>
                        <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Search') }}</h4>
                        <div class="relative mt-1">
                            <input type="text"
                                wire:model.live.debounce.300ms="search"
                                class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full pl-10"
                                placeholder="Search..." />
                            <a href="javascript:void(0)" class="flex absolute left-3.5 top-1/2 justify-center items-center -translate-y-1/2">
                                <x-icon-search-icon />
                            </a>
                        </div>
                    </div>
                    <div class="py-6 border-b border-solid border-gray-1600" x-data="{ openLocation: false }">
                        <a href="javascript:void(0)"
                            @click="openLocation = !openLocation"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Location') }}</h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse"
                            x-show="openLocation"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            @if ($countryList->isNotEmpty())
                                <ul>
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="country-{{ __('all') }}"
                                                type="radio"
                                                value=""
                                                wire:model.live.debounce.100ms="country"
                                                class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="country-{{ __('all') }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                {{ __('All Locations') }}
                                            </label>
                                        </div>
                                    </li>
                                    @foreach ($countryList as $country)
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="country-{{ $country->slug }}"
                                                    type="radio"
                                                    value="{{ $country->slug }}"
                                                    wire:model.live.debounce.100ms="country"
                                                    class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="country-{{ $country->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                    {{ $country->country_name }}
                                                    <span class="text-xs leading-4 text-mid-gray">{{ $country->jobs()->count() }}</span>
                                                </label>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                            @if ($country)
                                @if ($stateList->isNotEmpty())
                                    <div class="mt-3 mb-4">
                                        <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('State') }}</h4>
                                        <div class="relative mt-1">
                                            <select wire:model.live.debounce.100ms="state" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                                <option>{{ __('Select State') }}</option>
                                                @foreach ($stateList as $state)
                                                    <option value="{{ $state->slug }}">{{ $state->state_name }}</option>
                                                @endforeach
                                            </select>
                                            <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2">
                                                <x-icon-down-arrow-outline />
                                            </span>
                                        </div>
                                    </div>
                                @endif
                                @if ($state)
                                    <div>
                                        <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                            {{ __('City or Zip') }}
                                        </h4>
                                        {{-- Replace the standard input with the address-autocomplete component --}}
                                        <div class="relative mt-1" x-data="{ lat: null, lng: null }">
                                            <input id="city-input-{{ $this->id() }}"
                                                type="text"
                                                wire:model.live.debounce.50ms="city"
                                                placeholder="{{ __('Enter city or zip') }}"
                                                class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3" />
                                            {{-- Clear icon that only appears when there's a value --}}
                                            {{-- Clear icon that only appears when there's a value --}}
                                            @if ($city)
                                                <button type="button"
                                                    x-on:click="$wire.set('city', null); $wire.set('lat', null); $wire.set('lng', null);"
                                                    class="absolute right-4 top-1/2 text-gray-500 -translate-y-1/2 hover:text-gray-700 focus:outline-none"
                                                    title="{{ __('Clear') }}">
                                                    <x-icon-clear-field class="w-5 h-5" />
                                                </button>
                                            @endif

                                            <input type="hidden"
                                                id="lat-{{ $this->getId() }}"
                                                wire:model="lat"
                                                x-model="lat">

                                            <input type="hidden"
                                                id="lng-{{ $this->getId() }}"
                                                wire:model="lng"
                                                x-model="lng">
                                        </div>

                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                    <div class="py-6 border-b border-solid border-gray-1600">

                        <div class="ilter-collapse"
                            x-show="true"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            @foreach ($jobRoleList as $parentRole)
                                @if ($parentRole->children->isNotEmpty())
                                    <div x-data="{ open{{ $parentRole->id }}: false }" class="{{ $loop->iteration > 1 ? 'mt-6' : '' }}">
                                        <a href="javascript:void(0)"
                                            @click="open{{ $parentRole->id }} = !open{{ $parentRole->id }}"
                                            class="flex justify-between items-center collapse-btn">
                                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                                {{ $parentRole->job_role_name }}
                                            </h4>
                                            <span class="flex justify-center items-center w-5 h-5" :class="{ 'rotate-180': open{{ $parentRole->id }} }">
                                                <x-icon-down-arrow-outline />
                                            </span>
                                        </a>

                                        <div class="mt-3 filter-collapse"
                                            x-show="open{{ $parentRole->id }}"
                                            x-transition:enter="transition duration-300 ease-in-out"
                                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                                            x-transition:enter-end="opacity-100 transform translate-y-0">
                                            <ul>
                                                @foreach ($parentRole->children as $childRole)
                                                    <li>
                                                        <div class="flex items-center mb-2">
                                                            <input id="role-{{ $childRole->id }}"
                                                                type="checkbox"
                                                                value="{{ $childRole->slug }}"
                                                                wire:model.live.debounce.100ms="job_role"
                                                                class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                            <label for="role-{{ $childRole->id }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                                {{ $childRole->job_role_name }}
                                                                <span class="text-xs leading-4 text-mid-gray">({{ $childRole->jobs()->count() }})</span>
                                                            </label>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                @else
                                    <div class="flex items-center mb-2">
                                        <input id="role-{{ $parentRole->id }}"
                                            type="checkbox"
                                            value="{{ $parentRole->slug }}"
                                            wire:model.live.debounce.100ms="job_role"
                                            class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="role-{{ $parentRole->id }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                            {{ $parentRole->job_role_name }}
                                            <span class="text-xs leading-4 text-mid-gray">({{ $parentRole->jobs()->count() }})</span>
                                        </label>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>

                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            @click="openExperience = !openExperience"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                {{ __('Experience Level') }}
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse"
                            x-show="openExperience"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            <div x-data="{ showAllCareerLevels: false }">
                                @if ($jobCareerLevelList->isNotEmpty())
                                    <ul>
                                        @foreach ($jobCareerLevelList->take(3) as $jobCareerLevel)
                                            <li>
                                                <div class="flex items-center mb-2">
                                                    <input id="career-level-{{ $jobCareerLevel->slug }}"
                                                        type="checkbox"
                                                        value="{{ $jobCareerLevel->slug }}"
                                                        wire:model.live.debounce.100ms="career_level"
                                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="career-level-{{ $jobCareerLevel->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                        {{ $jobCareerLevel->career_level_name }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                                @if ($jobCareerLevelList->count() > 3)
                                    <div x-show="showAllCareerLevels"
                                        x-transition:enter="transition duration-300 ease-in-out"
                                        x-transition:enter-start="opacity-0 transform -translate-y-2"
                                        x-transition:enter-end="opacity-100 transform translate-y-0">
                                        <ul>
                                            @foreach ($jobCareerLevelList->skip(3) as $jobCareerLevel)
                                                <li>
                                                    <div class="flex items-center mb-2">
                                                        <input id="career-level-{{ $jobCareerLevel->slug }}"
                                                            type="checkbox"
                                                            value="{{ $jobCareerLevel->slug }}"
                                                            wire:model.live.debounce.100ms="career_level"
                                                            class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                        <label for="career-level-{{ $jobCareerLevel->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                            {{ $jobCareerLevel->career_level_name }}
                                                        </label>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <a @click="showAllCareerLevels = !showAllCareerLevels" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                    <span x-text="showAllCareerLevels ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($jobCareerLevelList) }}'"></span>
                                    <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllCareerLevels }">
                                        <x-icon-down-arrow-outline />
                                    </span>
                                </a>
                            </div>
                        </div>
                    </div>
                    {{-- @endif --}}

                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            @click="openJobType = !openJobType"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                {{ __('Job Type') }}
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse"
                            x-show="openJobType"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            @if ($jobTypeList->isNotEmpty())
                                <div x-data="{ showAllJobTypes: false }">
                                    <ul>
                                        @foreach ($jobTypeList->take(3) as $jobType)
                                            <li>
                                                <div class="flex items-center mb-2">
                                                    <input id="job-type-{{ $jobType->slug }}"
                                                        type="checkbox"
                                                        value="{{ $jobType->slug }}"
                                                        wire:model.live.debounce.100ms="job_type"
                                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="job-type-{{ $jobType->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                        {{ $jobType->job_type_name }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>
                                    @if ($jobTypeList->count() > 3)
                                        <div x-show="showAllJobTypes"
                                            x-transition:enter="transition duration-300 ease-in-out"
                                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                                            x-transition:enter-end="opacity-100 transform translate-y-0">
                                            <ul>
                                                @foreach ($jobTypeList->skip(3) as $jobType)
                                                    <li>
                                                        <div class="flex items-center mb-2">
                                                            <input id="job-type-{{ $jobType->slug }}"
                                                                type="checkbox"
                                                                value="{{ $jobType->slug }}"
                                                                wire:model.live.debounce.100ms="job_type"
                                                                class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                            <label for="job-type-{{ $jobType->slug }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                                {{ $jobType->job_type_name }}
                                                            </label>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                    <a @click="showAllJobTypes = !showAllJobTypes" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                        <span x-text="showAllJobTypes ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($jobTypeList) }}'"></span>
                                        <span class="transition-transform duration-300 transform" :class="{ 'rotate-180 transition-transform duration-300': showAllJobTypes }">
                                            <x-icon-down-arrow-outline />
                                        </span>
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            @click="openWorkingHours = !openWorkingHours"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                {{ __('Working Hours') }}
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse"
                            x-show="openWorkingHours"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">

                            @if (!empty($jobShiftList))
                                <div x-data="{ showAllJobShifts: false }">
                                    <ul>
                                        @foreach ($jobShiftList as $index => $jobShift)
                                            <li x-show="showAllJobShifts || {{ $index }} < 2"
                                                x-transition:enter="transition duration-300 ease-in-out"
                                                x-transition:enter-start="opacity-0 transform -translate-y-2"
                                                x-transition:enter-end="opacity-100 transform translate-y-0">
                                                <div class="flex items-center mb-2">
                                                    <input id="job-shift-{{ $jobShift->value }}"
                                                        type="checkbox"
                                                        value="{{ $jobShift->value }}"
                                                        wire:model.live.debounce.100ms="shift"
                                                        class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                    <label for="job-shift-{{ $jobShift->value }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                        {{ $jobShift->getLabel() }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    </ul>

                                    @if (count($jobShiftList) > 2)
                                        <a @click="showAllJobShifts = !showAllJobShifts" class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-2 text-primary-blue cursor-pointer">
                                            <span x-text="showAllJobShifts ? '{{ __('Show less') }}' : '{{ __('Show all') }} {{ count($jobShiftList) }}'"></span>
                                            <span class="transition-transform duration-300 transform" :class="{ 'rotate-180': showAllJobShifts }">
                                                <x-icon-down-arrow-outline />
                                            </span>
                                        </a>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            @click="openRemoteWork = !openRemoteWork"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">Remote Work</h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse"
                            x-show="openRemoteWork"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            @if (!empty($workModeList))
                                <ul>
                                    @foreach ($workModeList as $workMode)
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="work-mode-{{ $workMode->value }}"
                                                    type="checkbox"
                                                    value="{{ $workMode->value }}"
                                                    wire:model.live.debounce.100ms="work_mode"
                                                    class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="work-mode-{{ $workMode->value }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                    {{ $workMode->getLabel() }}
                                                </label>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    </div>
                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            @click="openSalary = !openSalary"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">{{ __('Salary Range (USD)') }}</h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse"
                            x-show="openSalary"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            <div class="mb-4">
                                <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                    {{ __('Min Salary') }}
                                </h4>
                                <div class="relative mt-1">
                                    <input type="text"
                                        wire:model.live.debounce.100ms="min_salary"
                                        placeholder="$ 0.00"
                                        class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                </div>
                            </div>
                            <div class="">
                                <h4 class="text-sm text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                    {{ __('Max Salary') }}
                                </h4>
                                <div class="relative mt-1">
                                    <input type="text"
                                        placeholder="$ 0.00"
                                        wire:model.live.debounce.100ms="max_salary"
                                        class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="py-6 border-b border-solid border-gray-1600">
                        <a href="javascript:void(0)"
                            @click="openDatePosted = !openDatePosted"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">Date Posted
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse"
                            x-show="openDatePosted"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            @if (!empty($datePostedList))
                                <ul>
                                    <li>
                                        <div class="flex items-center mb-2">
                                            <input id="date-posted-all"
                                                type="radio"
                                                value=""
                                                wire:model.live="date_posted"
                                                class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="date-posted-all" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                {{ __('All') }}
                                            </label>
                                        </div>
                                    </li>
                                    @foreach ($datePostedList as $datePosted)
                                        <li>
                                            <div class="flex items-center mb-2">
                                                <input id="date-posted-{{ $datePosted['id'] }}"
                                                    type="radio"
                                                    value="{{ $datePosted['id'] }}"
                                                    wire:model.live="date_posted"
                                                    class="w-4 h-4 bg-transparent rounded-full shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                                <label for="date-posted-{{ $datePosted['id'] }}" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                                    {{ $datePosted['name'] }}
                                                </label>
                                            </div>
                                        </li>
                                    @endforeach

                                </ul>
                            @endif
                        </div>
                    </div>
                    <div class="pt-6">
                        <a href="javascript:void(0)"
                            @click="openDeadline = !openDeadline"
                            class="flex justify-between items-center collapse-btn">
                            <h4 class="text-base text-black-1200 font-medium leading-5 tracking-[-0.096px]">
                                {{ __('Application Deadline') }}
                            </h4>
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-down-arrow-outline />
                            </span>
                        </a>
                        <div class="mt-3 filter-collapse"
                            x-show="openDeadline"
                            x-transition:enter="transition duration-300 ease-in-out"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0">
                            <ul>
                                <li>
                                    <div class="flex items-center mb-2">
                                        <input id="application-open-jobs-only"
                                            type="checkbox"
                                            value=""
                                            wire:model.live="openJobsOnly"
                                            class="w-4 h-4 bg-transparent rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="application-open-jobs-only" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200 flex items-center justify-between flex-1 w-full">
                                            {{ __('Open Jobs Only') }}
                                        </label>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="block absolute bottom-0 left-0 p-6 w-full bg-white border-t border-solid lg:hidden border-gray-1200">
            <a href="javascript:void(0)"
                @click="openFilter = false; $wire.applySearch()"
                class="primary-btn">{{ __('Showing :total+ Results', ['total' => $jobs->total()]) }}</a>
        </div>
    </div>
</div>
