@props(['member', 'viewType' => 'list', 'loop' => null, 'desktopSlides' => 4])
@php
    use Illuminate\Support\Str;
    $rating = $member?->ratingCount()['rating'] ?? 0;
    $reviewCount = $member?->ratingCount()['count'] ?? 0;
    $businessSince = $member?->profile?->year_established;
    $reviewsStats = $member?->getUserReviewsStats();
    $average_rating = $reviewsStats['average_rating'] ?? 0;
    $rating_count = $reviewsStats['total_reviews'] ?? 0;
    $rating_types = $reviewsStats['rating_types'] ?? [];
    $rating_distribution = $reviewsStats['rating_distribution'] ?? [];
    $phone = $member->profile?->phone ?? $member->profile?->mobile;
    $video = $member->videos()->first();
    $gallery = $member->getMedia('gallery');
    $totalImages = $gallery->count();
    $rating = $member?->ratingCount()['rating'] ?? 0;
    $reviewCount = $member?->ratingCount()['count'] ?? 0;
    $addressType = $viewType === 'list' ? 'short' : 'area';
    $address = $member->address($addressType);
@endphp

{{-- <div data-member-id="{{ $member->uuid }}"
    data-lat="{{ $member->primaryLocation?->latitude }}"
    data-lng="{{ $member->primaryLocation?->longitude }}"
    data-member-name="{{ $member->memberName() }}"
    class="relative feature-card sm:px-6 px-4 sm:pb-6 pb-4 pt-10 mb-8 bg-white rounded-2xl border border-solid transition-all duration-500 ease-in-out cursor-pointer shadow-10xl border-gray-1200"> 

    <div class="feature-action-tag">
        <span class="relative z-10"> {{ __('Featured') }}</span>
        <div class="tag-shape absolute left-0  top-[37px] flex items-center">
            <x-icon-feature-shape />
        </div>
    </div>
    --}}

{{-- 
    <div class="flex md:flex-row flex-col md:items-center items-start xl:gap-6 md:gap-5 gap-6">
        <div class="max-w-[100px] w-full h-[100px] rounded-2xl border border-solid border-gray-1200 relative">
            <x-frontend.member.profile.partials.profile-avatar :user="$member" />
            @if ($member->isVerified())
                <span class="flex absolute -top-3.5 -right-3.5 justify-center items-center md:-right-4 md:-top-4">
                    <x-icon-verify-icon />
                </span>
            @endif
        </div>

        <div class="flex-1 w-full">
            <div class="">
                <a href="{{ route('member.show', $member->slug) }}">
                    <h4 class="md:text-[32px] text-2xl font-medium md:leading-10 leading-8 md:tracking-[-0.16px] tracking-[-0.12px] text-black-1200 flex items-center gap-3">
                        {{ $member->memberName() }}
                        @if ($member->membershipType->value == App\Enums\MembershipType::Pro->value)
                            <span class="inline-flex items-center justify-center font-medium text-xs border border-solid border-primary-blue bg-blue-1200 px-[7px] text-primary-blue gap-[5px] rounded-full h-6">
                                <x-icon-pro-current />
                                {{ __('Pro') }}
                            </span>
                        @endif
                    </h4>
                </a>
                @if ($member->profile?->slogan)
                    <h5 class="md:text-xl text-base font-medium capitalize md:leading-7 leading-6 text-mid-gray md:mt-1.5 mt-2">
                        {{ Str::headline($member->profile?->slogan) }}
                    </h5>
                @endif
                <div class="flex flex-wrap md:flex-row gap-2 flex-col items-start mt-1">
                    @if ($rating_count > 0)
                        <ul class="flex items-center xl:gap-[5px] gap-0.5">
                            @if (!empty($average_rating))
                                <x-frontend.review.partials.review-average-star-yellow :rating="$average_rating" />
                            @endif
                            @if ($rating_count > 0)
                                <li class="ml-1.5"><a class="flex items-center font-medium xl:text-sm md:text-[11px] text-sm md:tracking-[-0.096px] tracking-[-0.084px] text-mid-gray underline underline-offset-2">
                                        {{ $rating_count }}
                                        {{ Str::headline('reviews') }}
                                    </a>
                                </li>
                            @endif
                        </ul>
                    @endif
                    @if (!empty($address) || !empty($businessSince))
                        <ul class="flex flex-wrap flex-col items-start mt-2 md:flex-row md:items-center md:mt-0 {{ $rating_count > 0 ? 'md:ml-2' : '' }}">
                            @if (!empty($address))
                                <li class="md:mb-0 mb-2 text-mid-gray font-medium xl:text-sm md:text-[11px] text-sm md:tracking-[-0.096px] tracking-[-0.084px] flex items-center xl:gap-2 gap-1 xl:pr-2 md:pr-1 {{ $rating_count > 0 ? 'md:border-l border-solid border-gray-1200 xl:pl-2 md:pl-1' : '' }}">
                                    <span class="flex justify-center items-center w-5 h-5"><x-icon-location-outline-v2 /></span>{{ Str::headline($member->address('short')) }}
                                </li>
                            @endif
                            @if (!empty($businessSince))
                                <li class="text-mid-gray font-medium xl:text-sm  md:text-[11px] text-sm md:tracking-[-0.096px] tracking-[-0.084px] flex items-center xl:gap-2 gap-1 xl:pl-2 md:pl-1 {{ !empty($address)  ? 'md:border-l border-solid border-gray-1200 xl:pr-2 md:pr-1' : '' }}">
                                    <span class="flex justify-center items-center w-5 h-5">
                                        <x-icon-business-icon />
                                    </span>{{ Str::headline('In Business since') }} {{ $businessSince }}
                                </li>
                            @endif
                        </ul>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @if ($member->parentCategories() || $member->profile?->getMeta('emergency_service_enabled') || $member->profile?->getMeta('profile_tags') || $member->primaryLocation?->areas()->exists())
        <div class="mt-6">
            @if ($member->parentCategories())
                <ul class="flex items-center sm:flex-nowrap flex-wrap gap-2 mb-3">
                    @foreach ($member->parentCategories() as $category)
                        <li>
                            <a href="#" class="chip-tags2">
                                @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                            </a>
                        </li>
                    @endforeach
                </ul>
            @endif
            @if ($member->profile?->getMeta('emergency_service_enabled') || $member->profile?->getMeta('profile_tags'))
                <ul class="flex items-center flex-wrap gap-2">
                    @if ($member->profile?->getMeta('emergency_service_enabled'))
                        <li class="inline-flex px-2.5 items-center justify-center text-blue-1500 font-medium  text-sm leading-5 tracking-[-0.096px] bg-blue-1400/[0.1] rounded-md h-7 gap-1.5">
                            <x-icon-check-icon2 />
                            {{ __('24/7 Emergency Service') }}
                        </li>
                    @endif
                    @if ($member->profile?->getMeta('profile_tags'))
                        @foreach ($member->profile?->getMeta('profile_tags') as $tag)
                            <li class="inline-flex px-2.5 items-center justify-center text-blue-1500 font-medium  text-sm leading-5 tracking-[-0.096px] bg-blue-1400/[0.1] rounded-md h-7 gap-1.5">
                                <x-icon-check-icon2 />
                                {{ Str::headline($tag) }}
                            </li>
                        @endforeach
                    @endif
                </ul>
            @endif
            @if ($member->primaryLocation?->areas()->exists())
                <ul class="flex items-center flex-wrap gap-2 mt-3">
                    @foreach ($member->primaryLocation?->areas()->get() as $area)
                        @if (!empty($area?->name))
                            <li><a href="#" class="chip-tags">{{ Str::headline($area?->name) }}</a></li>
                        @endif
                    @endforeach
                </ul>
            @endif
        </div>
    @endif
    @if ($totalImages > 0)
        <div class="relative {{ $member->profile?->getMeta('emergency_service_enabled') || $member->profile?->getMeta('profile_tags') || $member->primaryLocation?->areas()->exists() ? 'mt-6' : '' }}">
            @if ($totalImages > 5)
                <div class="absolute left-0 top-0 z-50 h-full md:w-[107px] w-12 bg-gradient-to-l from-black-1200/[0] to-black-1200">
                </div>
            @endif
            @if ($totalImages > 5)
                <div class="absolute right-0 top-0 z-50 h-full md:w-[72px] w-12 bg-gradient-to-r from-black-1200/[0] to-black-1200">
                </div>
            @endif
            <div class="swiper memberFeatureSwiper">
                <div class="swiper-wrapper">
                    @foreach ($member->getMedia('gallery') as $image)
                        <div class="swiper-slide">
                            <a href="{{ $image->getUrl('medium') }}"
                                class="member-feature-gallery-item"
                                data-src="{{ $image->getUrl('medium') }}"
                                data-sub-html="{{ $image->name ?? 'Gallery Image' }}">
                                <img src="{{ $image->getUrl('medium') }}"
                                    alt="{{ $image->name ?? 'Gallery Image' }}"
                                    class="w-full h-[114px] object-cover object-center rounded-xl"
                                    loading="lazy" />
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
            @if ($totalImages > 5)
                <div class="swiper-button-next swiper-button-next2 bg-white !z-[100]  !right-0 !w-8 !h-8 !top-1/2 !-translate-y-1/2 !mt-0 rounded-full flex items-center justify-center after:hidden">
                    <x-icon-swiper-right-v1 />
                </div>
            @endif
            @if ($totalImages > 5)
                <div class="swiper-button-prev swiper-button-prev2 bg-white !z-[100] !left-0 !w-8 !h-8 !top-1/2 !-translate-y-1/2 !mt-0 rounded-full flex items-center justify-center after:hidden">
                    <x-icon-swiper-left-v1 />
                </div>
            @endif
        </div>
    @endif
    @if ($video || !empty($member->email) || !empty($phone))
        <ul class="grid sm:grid-cols-2 grid-cols-1 gap-3 mt-6 md:grid-cols-4">
            @if ($video)
                <li>
                    <x-frontend.includes.video-modal-button :video="$video" class="group w-full  text-mid-gray shadow-23xl hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.084px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                        <x-icon-play-fill />
                        {{ __('Watch Video') }}
                    </x-frontend.includes.video-modal-button>
                </li>
            @endif

            <li>
                <a href="{{ route('member.show', $member->slug) }}" class="group w-full text-mid-gray shadow-23xl hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.084px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                    <x-icon-right-arrow-top />
                    {{ __('View Profile') }}
                </a>
            </li>

            @if (!empty($member->email))
                <li>
                    <x-frontend.includes.contact-modal-button :user="$member" class="group w-full text-mid-gray shadow-23xl hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.084px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                        <x-icon-chat-outline-v2 />
                        {{ __('Message us') }}
                    </x-frontend.includes.contact-modal-button>
                </li>
            @endif
            @if (!empty($phone))
                <li>
                    <a href="tel:{{ $phone }}" class="group feature-btn  w-full feature-gradient  text-white font-medium text-sm leading-5 tracking-[-0.084px]  inline-flex items-center justify-center rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                        <x-icon-call-outline-v2 />
                        {{ __('Call Now') }}
                    </a>
                </li>
            @endif
        </ul>
    @endif
</div> --}}

<div data-member-id="{{ $member->uuid }}"
    data-lat="{{ $member->primaryLocation?->latitude }}"
    data-lng="{{ $member->primaryLocation?->longitude }}"
    data-member-name="{{ $member->memberName() }}"
    class="relative feature-card sm:px-6 px-4 sm:pb-6 pb-4 pt-10 bg-white rounded-2xl border border-l-[3px] border-r-[3px] border-solid transition-all duration-500 ease-in-out cursor-pointer shadow-10xl border-gray-1200">
    <div class="feature-action-tag">
        <span class="relative z-10">{{ __('Featured') }}</span>
        <div class="tag-shape absolute left-0 top-[37px] flex items-center">
            <x-icon-feature-shape />
        </div>
    </div>
    <div class="flex md:flex-row flex-col md:items-center items-start xl:gap-6 md:gap-5 gap-6">
        <div class="max-w-[100px] w-full h-[100px] rounded-2xl border border-solid border-gray-1200 relative">
            <x-frontend.member.profile.partials.profile-avatar :user="$member" class="p-2.5 w-full h-full" />
            @if ($member->isVerified())
                <span class="flex absolute -top-3.5 -right-3.5 justify-center items-center md:-right-4 md:-top-4">
                    <x-icon-verify-icon />
                </span>
            @endif
        </div>
        <div class="flex-1 w-full">
            <div class="">
                <a href="{{ route('member.show', $member->slug) }}">
                    <h4 class="md:text-[32px] text-2xl font-medium md:leading-10 leading-8 md:tracking-[-0.16px] tracking-[-0.12px] text-black-1200 flex items-center gap-3">
                        {{ $member->memberName() }}
                        <span class="inline-flex items-center justify-center font-medium text-xs border border-solid border-primary-blue bg-blue-1200 px-[7px] text-primary-blue gap-[5px] rounded-full h-6">
                            <x-icon-pro-current />
                            {{ __('Pro') }}
                        </span>
                    </h4>
                </a>
                @if ($member->profile?->slogan)
                    <h5 class="md:text-xl text-base font-medium capitalize md:leading-7 leading-6 text-mid-gray md:mt-1.5 mt-2">
                        {{ Str::headline($member->profile?->slogan) }}
                    </h5>
                @endif

                <div class="flex flex-wrap md:flex-row gap-2 flex-col items-start mt-1">
                    @if ($rating_count > 0)
                        <ul class="flex items-center xl:gap-[5px] gap-0.5">
                            @if (!empty($average_rating))
                                <x-frontend.review.partials.review-average-star-yellow :rating="$average_rating" />
                            @endif
                            @if ($rating_count > 0)
                                <li class="ml-1.5">
                                    <a class="flex items-center font-medium xl:text-sm md:text-[11px] text-sm md:tracking-[-0.096px] tracking-[-0.084px] text-mid-gray underline underline-offset-2">
                                        {{ $rating_count }}
                                        {{ Str::headline('reviews') }}
                                    </a>
                                </li>
                            @endif
                        </ul>
                    @endif
                    @if (!empty($address) || !empty($businessSince))
                        <ul class="flex flex-wrap flex-col items-start mt-2 md:flex-row md:items-center md:mt-0 {{ $rating_count > 0 ? 'md:ml-2' : '' }}">
                            @if (!empty($address))
                                <li class="md:mb-0 mb-2 text-mid-gray font-medium xl:text-sm  md:text-[11px] text-sm md:tracking-[-0.096px] tracking-[-0.084px] flex items-center xl:gap-2 gap-1  xl:pr-2 md:pr-1 {{ $rating_count > 0 ? 'md:border-l border-solid border-gray-1200 xl:pl-2 md:pl-1' : '' }}">
                                    <span class="flex justify-center items-center w-5 h-5">
                                        <x-icon-location-outline-v2 />
                                    </span>
                                    {{ Str::headline($address) }}
                                </li>
                            @endif
                            @if (!empty($businessSince))
                                <li class="text-mid-gray font-medium xl:text-sm  md:text-[11px] text-sm md:tracking-[-0.096px] tracking-[-0.084px] flex items-center xl:gap-2 gap-1 {{ $rating_count > 0 || !empty($address) ? 'md:border-l border-solid border-gray-1200 xl:pl-2 md:pl-1' : '' }}">
                                    <span class="flex justify-center items-center w-5 h-5">
                                        <x-icon-business-icon />
                                    </span>
                                    {{ Str::headline('In Business since') }} {{ $businessSince }}
                                </li>
                            @endif
                        </ul>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @if ($member->parentCategories() || $member->profile?->getMeta('emergency_service_enabled') || $member->profile?->getMeta('profile_tags') || $member->primaryLocation?->areas()->exists())
        <div class="mt-6">
            @if ($member->parentCategories())
                <ul class="flex items-center sm:flex-nowrap flex-wrap gap-2 mb-3">
                    @foreach ($member->parentCategories() as $category)
                        <li>
                            <a href="#" class="chip-tags3">
                                @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                            </a>
                        </li>
                    @endforeach
                </ul>
            @endif
            @if ($member->profile?->getMeta('emergency_service_enabled') || $member->profile?->getMeta('profile_tags'))
                <ul class="flex items-center flex-wrap gap-2">
                    @if ($member->profile?->getMeta('emergency_service_enabled'))
                        <li class="inline-flex px-2.5 items-center justify-center text-blue-1500 font-medium  text-sm leading-5 tracking-[-0.096px] bg-blue-1400/[0.1] rounded-md h-7 gap-1.5">
                            <x-icon-check-icon2 />
                            {{ __('24/7 Emergency Service') }}
                        </li>
                    @endif
                    @if ($member->profile?->getMeta('profile_tags'))
                        @foreach ($member->profile?->getMeta('profile_tags') as $tag)
                            <li class="inline-flex px-2.5 items-center justify-center text-blue-1500 font-medium  text-sm leading-5 tracking-[-0.096px] bg-blue-1400/[0.1] rounded-md h-7 gap-1.5">
                                <x-icon-check-icon2 />
                                {{ Str::headline($tag) }}
                            </li>
                        @endforeach
                    @endif
                </ul>
            @endif
            @if ($member->primaryLocation?->areas()->exists())
                <h4 class="text-mid-gray font-medium text-sm leading-5 tracking-[-0.084px] my-3">{{ __('Service Areas') }}</h4>
                <ul class="flex items-center flex-wrap gap-2">
                    @foreach ($member->primaryLocation?->areas as $area)
                        @if ($area?->name)
                            <li>
                                <a href="#" class="chip-tags">{{ Str::headline($area?->name) }}</a>
                            </li>
                        @endif
                    @endforeach
                </ul>
            @endif
        </div>
    @endif
    @if ($totalImages > 0)
        <div class="relative {{ $member->profile?->getMeta('emergency_service_enabled') || $member->profile?->getMeta('profile_tags') || $member->primaryLocation?->areas()->exists() ? 'mt-6' : '' }}">
            @if ($totalImages > 5)
                <div class="absolute left-0 md:top-[19px] sm:top-[3px] top-0 z-50 h-[114px] md:w-[107px] w-12  bg-gradient-to-l from-black-1200/[0] from-[29.44%] to-black-1200 to-[111.78%]">
                </div>
            @endif
            @if ($totalImages > 5)
                <div class="absolute right-0 md:top-[19px] sm:top-[3px] top-0 z-50 h-[114px] md:w-[72px] w-12  bg-gradient-to-r from-black-1200/[0] from-[29.44%] to-black-1200 to-[111.78%]">
                </div>
            @endif
            <div class="swiper memberFeatureSwiper sm:pb-[110px]! sm:mb-[-110px]">
                <div class="swiper-wrapper">
                    @foreach ($member->getMedia('gallery') as $image)
                        <div class="swiper-slide">
                            <a href="{{ $image->getUrl('medium') }}"
                                class="member-feature-gallery-item"
                                data-src="{{ $image->getUrl('medium') }}"
                                data-sub-html="{{ $image->name ?? 'Gallery Image' }}">
                                <img src="{{ $image->getUrl('medium') }}"
                                    alt="{{ $image->name ?? 'Gallery Image' }}"
                                    class="w-full h-[114px] object-cover object-center rounded-xl"
                                    loading="lazy" />
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
            @if ($totalImages > 5)
                <div class="swiper-button-next swiper-button-next2 bg-white !z-[100]  !right-0 !w-8 !h-8 !top-1/2 !-translate-y-1/2 !mt-0 rounded-full sm:hidden! flex! items-center justify-center after:hidden ">
                    <x-icon-swiper-right-v1 class="text-[#525866]" />
                </div>
            @endif
            @if ($totalImages > 5)
                <div class="swiper-button-prev swiper-button-prev2 bg-white !z-[100] !left-0 !w-8 !h-8 !top-1/2 !-translate-y-1/2 !mt-0 rounded-full sm:hidden! flex! items-center justify-center after:hidden">
                    <x-icon-swiper-left-v1 class="text-[#525866]" />
                </div>
            @endif
        </div>
    @endif
    <ul class="grid sm:grid-cols-2 grid-cols-1 gap-3 mt-6 md:grid-cols-3 mb-6">
        @if (!empty($phone))
            <li>
                <a href="tel:{{ $phone }}" class="group feature-btn !shadow-21xl btn-gradient  w-full   text-black font-medium text-sm leading-5 tracking-[-0.084px]  inline-flex items-center justify-center rounded-full h-10 transition-all duration-500 ease-in-out gap-3 text-black">
                    <x-icon-call-outline-v2 />
                    {{ __('Call Now') }}
                </a>
            </li>
        @endif

        <li>
            <a href="{{ route('member.show', $member->slug) }}" class="group feature-btn w-full feature-gradient text-white shadow-23xl hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.084px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                <x-icon-right-arrow-top />
                {{ __('View Profile') }}
            </a>
        </li>
        @if (!empty($member->email))
            <li>
                <x-frontend.includes.contact-modal-button :user="$member" class="group feature-btn w-full feature-gradient text-white shadow-23xl hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.084px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                    <x-icon-chat-outline-v2 />
                    {{ __('Message us') }}
                </x-frontend.includes.contact-modal-button>
            </li>
        @endif
    </ul>
    @if ($video)
        <x-frontend.includes.video-modal-button :video="$video" class="text-primary-blue h-10 text-sm font-medium leading-5 tracking-[-0.084px] flex items-center justify-center gap-2">
            <span class="flex items-center justify-center w-5 h-5">
                <x-icon-play-fill />
            </span>
            {{ __('Watch Video') }}
        </x-frontend.includes.video-modal-button>
    @endif
</div>
