@props(['member' => null, 'viewType' => 'list', 'loop' => null])
@php
    use Illuminate\Support\Str;
    $rating = $member->ratingCount()['rating'] ?? 0;
    $reviewCount = $member->ratingCount()['count'] ?? 0;
    $addressType = $viewType === 'list' ? 'short' : 'area';
    $address = $member->address($addressType);
    $businessSince = $member->profile?->year_established;
    $reviewsStats = $member->getUserReviewsStats();
    $average_rating = $reviewsStats['average_rating'] ?? 0;
    $rating_count = $reviewsStats['total_reviews'] ?? 0;
    $rating_types = $reviewsStats['rating_types'] ?? [];
    $rating_distribution = $reviewsStats['rating_distribution'] ?? [];
    $phone = $member->profile?->phone ?? $member->profile?->mobile;
    $video = $member->videos()->first();
@endphp
<div class="relative p-6 mb-6 bg-white rounded-2xl border border-solid transition-all duration-500 ease-in-out cursor-pointer border-gray-1200 hover:shadow-10xl shadow-7xl"
    data-member-id="{{ $member->uuid }}"
    data-lat="{{ $member->primaryLocation?->latitude }}"
    data-lng="{{ $member->primaryLocation?->longitude }}"
    data-member-name="{{ $member->memberName() }}">

    <span class="feature-tag">{{ __('Featured') }}</span>
    <div class="flex flex-col flex-1 gap-4 items-start mt-6 w-full md:flex-row md:gap-6">
        <div class="relative">
            <a href="{{ route('member.show', $member->slug) }}">
                <div class="relative border border-solid border-gray-1200 rounded-2xl md:w-[100px] w-[72px] p-1 md:h-[100px] h-[72px] flex items-center justify-center">
                    <x-frontend.member.profile.partials.profile-avatar :user="$member" class="object-cover object-center w-full h-full rounded-xl transition-all duration-500 ease-in-out" />
                    @if ($member->isVerified())
                        <span class="flex absolute -top-4 -right-4 justify-center items-center">
                            <x-icon-verify-icon />
                        </span>
                    @endif
                </div>
            </a>
        </div>
        <div class="w-full md:w-auto">
            <a href="{{ route('member.show', $member->slug) }}">
                <h4 class="text-black-1200 font-medium text-[32px] leading-10 flex md:flex-row flex-col-reverse md:items-center items-start gap-3">
                    {{ $member->memberName() }}
                    @if ($member->membershipType->value == App\Enums\MembershipType::Pro->value)
                        <span class="inline-flex items-center justify-center font-medium text-xs border border-solid border-primary-blue bg-blue-1200 px-[7px] text-primary-blue gap-[5px] rounded-full h-6">
                            <x-icon-pro-current />
                            {{ __('Pro') }}
                        </span>
                    @endif
                </h4>
            </a>
            @if ($member->profile?->slogan)
                <p class="mt-1.5 text-base font-medium leading-7 xl:text-xl text-black-1200">
                    {{ Str::headline($member->profile?->slogan) }}
                </p>
            @endif
            <div class="mt-1.5">
                <ul class="flex flex-col flex-wrap gap-y-2 items-start mt-2 md:flex-row md:items-center md:mt-0">
                    <li class="flex gap-1 items-center pr-2">
                        @if ($rating_count > 0)
                            <span>
                                <x-frontend.review.partials.review-average-star-yellow :rating="$average_rating" />
                            </span>
                            <a class="flex items-center font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] text-mid-gray hover:underline underline-offset-2">
                                {{ $rating_count }}
                                {{ Str::headline('reviews') }}
                            </a>
                        @else
                            <a class="flex items-center font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] text-mid-gray">
                                {{ Str::headline('No reviews') }}
                            </a>
                        @endif
                    </li>
                    @if (!empty($address))
                        <li class="text-mid-gray md:mb-0 mb-2 font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:border-l border-solid border-gray-1200 md:px-2">
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-location-outline-v2 />
                            </span>
                            {{ Str::headline($address) }}
                        </li>
                    @endif
                    @if (!empty($businessSince))
                        <li class="text-mid-gray font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:border-l border-solid border-gray-1200 md:px-2">
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-business-icon />
                            </span>
                            {{ Str::headline('In Business Since') }} {{ $businessSince }}
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </div>
    <div class="mt-6">
        <ul class="flex flex-wrap gap-2 items-center">
            @if ($member->profile->getMeta('emergency_service_enabled'))
                <li class="inline-flex px-2.5 items-center justify-center text-blue-1500 font-medium  text-sm leading-5 tracking-[-0.096px] bg-blue-1400/[0.1] rounded-md h-7 gap-1.5">
                    <x-icon-check-icon />
                    {{ Str::headline('24/7 Emergency Service') }}
                </li>
            @endif
            @if ($member->profile->getMeta('profile_tags'))
                @foreach ($member->profile->getMeta('profile_tags') as $tag)
                    <li class="inline-flex px-2.5 items-center justify-center text-blue-1500 font-medium  text-sm leading-5 tracking-[-0.096px] bg-blue-1400/[0.1] rounded-md h-7 gap-1.5">
                        <x-icon-check-icon />
                        {{ Str::headline($tag) }}
                    </li>
                @endforeach
            @endif
        </ul>
        @if ($member->primaryLocation?->areas()->exists())
            <ul class="hidden flex-wrap gap-2 items-center mt-3 md:flex">
                <li>
                    <p class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px] mr-2">{{ __('Serving:') }}</p>
                </li>
                @foreach ($member->getAreas() as $area)
                    <li><a href="#" class="chip-tags">{{ Str::headline($area->name) }}</a></li>
                @endforeach
            </ul>
        @endif
        <ul class="grid grid-cols-2 gap-3 mt-6 md:grid-cols-4">
            @if ($video)
                <li>
                    <x-frontend.includes.video-modal-button :video="$video" class="group w-full text-mid-gray hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                        <x-icon-play-fill />
                        {{ __('Watch Video') }}
                    </x-frontend.includes.video-modal-button>
                </li>
            @endif
            @if (!empty($phone))
                <li>
                    <a href="tel:{{ $phone }}" class="group w-full text-mid-gray hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                        <x-icon-call-outline-v2 />
                        {{ __('Call Now') }}
                    </a>
                </li>
            @endif
            @if (!empty($member->email))
                <li>
                    <x-frontend.includes.contact-modal-button :user="$member" class="group w-full cursor-pointer text-mid-gray hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3 text-mid-gray hover:text-black-1200">
                        <x-icon-chat-outline-v2 class="text-mid-gray hover:text-black-1200" /> {{ __('Message us') }}
                    </x-frontend.includes.contact-modal-button>
                </li>
            @endif
            <li>
                <a href="{{ route('member.show', $member->slug) }}" class="group w-full text-mid-gray hover:text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]  inline-flex items-center justify-center hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full h-10 transition-all duration-500 ease-in-out gap-3">
                    <x-icon-right-arrow-top />
                    {{ __('View Profile') }}
                </a>
            </li>
        </ul>
    </div>
</div>
