@props(['member', 'memberType' => null, 'loop'])

@php
    // Set member type based on the member object or fallback to the prop
    $type = $member->membershipType->value;

    // Force view type to be 'map' for this component
    $viewType = 'map';

    // Get coordinates from primaryLocation if it exists, otherwise fallback to direct properties
    $latitude = $member->primaryLocation->latitude ?? ($member->lat ?? '');
    $longitude = $member->primaryLocation->longitude ?? ($member->lng ?? '');
@endphp

{{-- We're reusing the member-card-v2 component since it already handles map view logic --}}
<div data-member-id="{{ $member->uuid }}"
    data-lat="{{ $latitude }}"
    data-lng="{{ $longitude }}"
    data-member-name="{{ $member->memberName() }}"
    class="member-card-map">
    <x-frontend.member.listing.member-card-v2 :member="$member"
        :member-type="$type"
        :loop="$loop"
        view-type="map" />
</div>
