@props(['member'])
@php
    use Illuminate\Support\Str;
    $category = $member->parentCategories(1)->first();
    $categoriesCount = $member->parentCategories()->count();
    $rating = $member->ratingCount()['rating'] ?? 0;
    $reviewCount = $member->ratingCount()['count'] ?? 0;
    $address = $member->address();
    $businessSince = $member->profile?->year_established;
    $reviewsStats = $member->getUserReviewsStats();
    $average_rating = $reviewsStats['average_rating'] ?? 0;
    $rating_count = $reviewsStats['total_reviews'] ?? 0;
    $rating_types = $reviewsStats['rating_types'] ?? [];
    $rating_distribution = $reviewsStats['rating_distribution'] ?? [];
    $phone = $member->profile?->phone ?? $member->profile?->mobile;
    $video = $member->videos()->first();
@endphp
<div class="bg-white border border-solid border-gray-1200 rounded-2xl shadow-7xl p-6 relative">
    <ul class="flex items-center gap-3 absolute right-6 top-6 z-10">
        <li>
            <x-frontend.includes.add-favorite-button module="member"
                :modelId="$member->uuid"
                :isFavorite="$member->isFavorite()"
                class="flex justify-center items-center w-9 h-9 bg-white rounded-full border border-solid transition-all duration-500 ease-in-out group shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 border-gray-1200">
                <x-icon-heart-circle-outline />
            </x-frontend.includes.add-favorite-button>
        </li>
        @if ($member->membershipType->value == App\Enums\MembershipType::Pro->value)
            <li>
                <x-frontend.includes.contact-modal-button :user="$member" class="flex justify-center items-center w-9 h-9 bg-white rounded-full border border-solid transition-all duration-500 ease-in-out group shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 border-gray-1200">
                    <x-icon-chat-outline-v2 class="text-mid-gray hover:text-black-1200" />
                </x-frontend.includes.contact-modal-button>
            </li>
        @endif

    </ul>
    <a href="{{ route('member.show', $member->slug) }}">

        <div class="max-w-[72px] w-full h-[72px] rounded-2xl border border-solid border-gray-1200 relative">
            <x-frontend.member.profile.partials.profile-avatar :user="$member" class="p-1 rounded-2xl" />
            @if ($member->isVerified())
                <span class="flex absolute -top-3.5 -right-3.5 justify-center items-center md:-right-4 md:-top-4">
                    <x-icon-verify-icon />
                </span>
            @endif
        </div>
    </a>
    <div class="mt-4">
        @if ($member->membershipType->value == App\Enums\MembershipType::Pro->value)
            <span class="inline-flex items-center justify-center font-medium text-xs border border-solid border-yellow-1200 bg-yellow-1300 px-[7px] text-yellow-1200 gap-[5px] rounded-full h-6 text-[#A78025]">
                {{ __('Pro +') }}
            </span>
        @endif
        <a href="{{ route('member.show', $member->slug) }}">
            <h4 class="text-black-1200 font-medium text-xl leading-7 mt-2.5 mb-1">{{ $member->memberName() }}</h4>
        </a>
        @if ($member->profile?->slogan)
            <p class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-2.5">
                {{ Str::headline($member->profile?->slogan) }}
            </p>
        @endif
        @if (!empty($category))
            <ul class="flex items-center gap-2 mb-3">
                <li>
                    <a href="#" class="tags">
                        @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                    </a>
                </li>
                @if ($categoriesCount > 1)
                    <li><a href="#" class="tags">{{ __('+') }}{{ $categoriesCount }}</a></li>
                @endif
            </ul>
        @endif
        <ul class="flex items-center gap-[5px] mb-2">
            @if ($rating_count > 0)
                <li>
                    <x-frontend.review.partials.review-average-star-yellow :rating="$average_rating" />
                </li>
                <li class="ml-1.5">
                    <a class="flex items-center font-medium text-sm tracking-[-0.096px] text-mid-gray underline underline-offset-2">
                        {{ $rating_count }}
                        {{ Str::headline('reviews') }}
                    </a>
                </li>
            @endif
        </ul>
        @if (!empty($address) || !empty($businessSince))
            <ul class="mb-6">
                @if (!empty($address))
                    <li class="text-mid-gray font-medium text-xs mb-2 leading-4 flex items-center sm:gap-2 gap-1.5">
                        <span class="flex justify-center items-center w-5 h-5">
                            <x-icon-location-outline-v2 />
                        </span>
                        {{ Str::headline($member->address('area')) }}
                    </li>
                @endif
                @if (!empty($businessSince))
                    <li class="text-mid-gray font-medium text-xs leading-4 flex items-center sm:gap-2 gap-1.5">
                        <span class="flex justify-center items-center w-5 h-5">
                            <x-icon-business-icon />
                        </span>
                        {{ Str::headline('In business since') }} {{ $businessSince }}
                    </li>
                @endif
            </ul>
        @endif
        <a href="{{ route('member.show', $member->slug) }}" class="secondary-btn text-[#A78025]">
            <x-icon-phone-icon />
            {{ __('Call') }}
        </a>
    </div>
</div>
