@props(['member' => null, 'viewType' => 'list', 'loop'])
@php
    use Illuminate\Support\Str;
    $rating = $member->ratingCount()['rating'] ?? 0;
    $reviewCount = $member->ratingCount()['count'] ?? 0;
    $addressType = $viewType === 'list' ? 'short' : 'area';
    $address = $member->address($addressType);
    $businessSince = $member->profile?->year_established;
    $reviewsStats = $member->getUserReviewsStats();
    $average_rating = $reviewsStats['average_rating'] ?? 0;
    $rating_count = $reviewsStats['total_reviews'] ?? 0;
    $rating_types = $reviewsStats['rating_types'] ?? [];
    $rating_distribution = $reviewsStats['rating_distribution'] ?? [];
    $phone = $member->profile?->phone ?? $member->profile?->mobile;
@endphp
<div class="relative p-6 mb-6 bg-white rounded-2xl border border-solid transition-all duration-500 ease-in-out cursor-pointer member-card-map border-gray-1200 hover:shadow-10xl shadow-7xl"
    data-member-id="{{ $member->uuid }}"
    data-lat="{{ $member->primaryLocation?->latitude }}"
    data-lng="{{ $member->primaryLocation?->longitude }}"
    data-member-name="{{ $member->memberName() }}">
    <ul class="flex absolute top-6 right-6 gap-3 items-center">
        <li>
            <x-frontend.includes.add-favorite-button module="member"
                :modelId="$member->uuid"
                :isFavorite="$member->isFavorite()"
                class="flex justify-center items-center w-9 h-9 bg-white rounded-full border border-solid transition-all duration-500 ease-in-out group shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 border-gray-1200">
                <x-icon-heart-circle-outline />
            </x-frontend.includes.add-favorite-button>
        </li>

        @if ($member->membershipType->value == App\Enums\MembershipType::Pro->value)
            <li>
                <x-frontend.includes.contact-modal-button :user="$member" class="flex justify-center items-center w-9 h-9 bg-white rounded-full border border-solid transition-all duration-500 ease-in-out group shadow-3xl hover:bg-gray-1400 hover:border-gray-1400 border-gray-1200">
                    <x-icon-chat-outline-v2 class="text-mid-gray hover:text-black-1200" />
                </x-frontend.includes.contact-modal-button>
            </li>
            @if ($phone)
                <li class="hidden md:block">
                    <a href="tel:{{ $phone }}" class="secondary-btn w-[73px] !h-9">
                        <x-icon-phone-circle-outline />
                        {{ __('Call') }}
                    </a>
                </li>
            @endif
        @endif

    </ul>
    <div class="flex flex-col flex-1 gap-4 items-start w-full md:flex-row md:gap-6">
        <div class="relative">
            <a href="{{ route('member.show', $member->slug) }}">
                <div class="relative border border-solid border-gray-1200 rounded-2xl md:w-[100px] w-[72px] p-1 md:h-[100px] h-[72px] flex items-center justify-center">
                    <x-frontend.member.profile.partials.profile-avatar :user="$member" class="object-cover object-center w-full h-full rounded-xl transition-all duration-500 ease-in-out" />
                    @if ($member->membershipType->value != App\Enums\MembershipType::Free->value)
                        @if ($member->isVerified())
                            <span class="flex absolute -top-4 -right-4 justify-center items-center">
                                <x-icon-verify-icon />
                            </span>
                        @endif
                    @endif
                </div>
            </a>
        </div>
        <div class="w-full md:w-auto">
            <a href="{{ route('member.show', $member->slug) }}">
                <h4 class="flex flex-col-reverse gap-3 items-start text-xl font-medium leading-8 text-black-1200 md:flex-row md:items-center">
                    {{ $member->memberName() }}
                    @if ($member->membershipType->value == App\Enums\MembershipType::Pro->value)
                        <span class="inline-flex items-center justify-center font-medium text-xs border border-solid border-primary-blue bg-blue-1200 px-[7px] text-primary-blue gap-[5px] rounded-full h-6">
                            <x-icon-pro-current />
                            {{ __('Pro') }}
                        </span>
                    @endif
                </h4>
            </a>
            @if ($member->profile?->slogan)
                <p class="font-medium text-sm leading-6 tracking-[-0.096px] text-black-1200 mt-1">
                    {{ Str::headline(str()->limit($member->profile?->slogan, 50)) }}
                </p>
            @endif

            @if ($member->parentCategories())
                <ul class="hidden flex-wrap gap-2 items-center mt-3 md:flex">
                    @if ($member->parentCategories()->isNotEmpty())
                        @foreach ($member->parentCategories() as $category)
                            <li>
                                <a href="{{ route('member.show', $category->slug) }}" class="tags">
                                    @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                                </a>
                            </li>
                        @endforeach
                    @else
                        <li>
                            <span class="text-gray-1500 font-normal text-[13px] leading-normal flex items-center gap-2">
                                {{ Str::headline('No categories') }}
                            </span>
                        </li>
                    @endif
                </ul>
            @endif
            <ul class="flex flex-wrap gap-2 items-center mt-3 md:hidden">
                @if ($member->parentCategories()->isNotEmpty())
                    @foreach ($member->parentCategories(1) as $category)
                        <li>
                            <a href="{{ route('member.show', $category->slug) }}" class="tags">
                                @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                            </a>
                        </li>
                        @if (count($member->parentCategories()) > 1)
                            <li><span class="tags">{{ __('+') }}{{ count($member->parentCategories()) - 1 }}</span></li>
                        @endif
                    @endforeach
                @else
                    <li><a>{{ Str::headline('No categories') }}</a></li>
                @endif
            </ul>
            <div class="mt-3 mb-6 md:mt-4 md:mb-0">
                <ul class="flex flex-col flex-wrap gap-y-2 items-start mt-2 md:flex-row md:items-center md:mt-0">
                    @if ($reviewCount > 0)
                        <li class="flex gap-1 items-center pr-2">
                            <span>
                                <x-frontend.review.partials.review-average-star-yellow :rating="$average_rating" />
                            </span>
                            <a class="flex items-center font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] text-mid-gray hover:underline underline-offset-2">
                                {{ $reviewCount }} {{ Str::headline('reviews') }}
                            </a>
                            {{-- @else
                            <a class="flex items-center font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] text-mid-gray">
                                {{ Str::headline('No reviews') }}
                            </a> --}}
                        </li>
                    @endif
                    @if (!empty($address))
                        <li class="text-mid-gray md:mb-0 mb-2 font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:pr-2 {{ $reviewCount > 0 ? 'md:border-l border-solid border-gray-1200 md:pl-2' : '' }}">
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-location-outline-v2 /></span>
                            {{ Str::headline($address) }}
                        </li>
                    @endif
                    @if (!empty($businessSince))
                        <li class="text-mid-gray font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:border-l border-solid border-gray-1200 md:px-2">
                            <span class="flex justify-center items-center w-5 h-5">
                                <x-icon-business-icon /></span>{{ __('In Business Since') }} {{ $businessSince }}
                        </li>
                    @endif
                </ul>
            </div>
            @if ($member->membershipType->value == App\Enums\MembershipType::Pro->value && $phone)
                <div class="block md:hidden">
                    <a href="tel:{{ $phone }}" class="secondary-btn">
                        <x-icon-phone-circle-outline />
                        {{ __('Call') }}
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
