@props(['member', 'isMobile' => false, 'viewType' => 'list'])

@php
    $rating = $member->ratingCount()['rating'] ?? 0;
    $reviewCount = $member->ratingCount()['count'] ?? 0;
    $businessSince = $member->profile?->year_established;
    $addressType = $viewType === 'list' ? 'short' : 'area';
    $location = $member->address($addressType);

@endphp

@if ($isMobile)
    <ul class="flex flex-wrap items-start justify-center sm:items-center sm:justify-start md:flex-nowrap">
        <li class="py-2.5 mb-2.5 sm:w-auto w-full text-gray-1500 pr-0 font-normal text-[13px] leading-normal flex items-center justify-center gap-1.5 border-b border-solid border-gray-1300">
            <x-icon-location3 />
            {{ $location }}
        </li>

        @if ($reviewCount)
            <li class="text-gray-1500 pr-3 px-font-normal text-[13px] leading-normal flex items-center gap-2">
                <strong class="text-primary-blue flex items-center justify-center rounded-2xl font-medium rounded-tl-none bg-yellow-1300 sm:w-[38px] w-[33px] sm:h-[23px] h-5">{{ number_format($rating, 1) }}</strong>
                <a href="#" class="flex items-center font-medium underline text-primary-blue">{{ $reviewCount }} Reviews</a>
            </li>
        @endif

        @if ($businessSince)
            <li class="text-gray-1500 pl-3 font-normal text-[13px] leading-normal flex items-center border-l border-solid border-gray-1600">
                In Business Since {{ $businessSince }}
            </li>
        @endif
    </ul>
@else
    <ul class="flex flex-col flex-wrap items-start mt-2 sm:items-center xl:flex-nowrap sm:flex-row">
        <li class="sm:pb-0 pb-2 sm:w-auto w-full text-gray-1500 sm:pr-3 pr-0 font-normal 2xl:text-[15px] sm:text-xs text-[13px] leading-normal flex items-center sm:gap-2 gap-1.5 ">
            <x-icon-location3 />
            {{ $location }}
        </li>

        @if ($reviewCount)
            <li class="sm:py-0 py-2 sm:w-auto w-full text-gray-1500 sm:px-3 px-0 font-normal 2xl:text-[15px] sm:text-xs text-[13px] leading-normal flex items-center gap-2 sm:border-l sm:border-b-0 border-b border-solid border-gray-1600">
                <strong class="text-primary-blue flex items-center justify-center rounded-2xl font-medium rounded-tl-none bg-yellow-1300 sm:w-[38px] w-[33px] sm:h-[23px] h-5">{{ number_format($rating, 1) }}</strong>
                <a href="#" class="flex items-center font-medium underline text-primary-blue">{{ $reviewCount }} Reviews</a>
            </li>
        @endif

        @if ($businessSince)
            <li class="sm:pt-0 pt-2 sm:w-auto w-full text-gray-1500 sm:pl-3 px-0 font-normal 2xl:text-[15px] sm:text-xs text-[13px] leading-normal flex items-center sm:border-l sm:border-b-0 border-b border-solid border-gray-1600">
                In Business Since {{ $businessSince }}
            </li>
        @endif
    </ul>
@endif
