<div class="bg-white absolute left-1/2 bottom-0 -translate-x-1/2 translate-y-[10px] border border-solid border-[#E1E4EA] rounded-2xl p-3 w-[292px] relative">
    {{-- Arrow pointer at the bottom --}}
    <div class="absolute -bottom-[13px] left-1/2 -translate-x-1/2 w-0 h-0 border-l-[13px] border-l-transparent border-r-[13px] border-r-transparent border-t-[13px] border-t-[#E1E4EA]"></div>
    <div class="absolute -bottom-[12px] left-1/2 -translate-x-1/2 w-0 h-0 border-l-[12px] border-l-transparent border-r-[12px] border-r-transparent border-t-[12px] border-t-white"></div>
    <div class="flex gap-3">
        <div class="relative border border-solid border-[#E1E4EA] rounded-2xl w-[84px] p-1 h-[84px] flex items-center justify-center">
            @if ($member['profile_image'])
                <img src="{{ $member['profile_image'] }}"
                    alt="{{ $member['name'] }}"
                    class="object-cover object-center w-full h-full rounded-xl">
            @endif
        </div>
        <div class="flex-1 w-full">
            <h4 class="text-base font-medium leading-6 text-[#0E121B] tracking-[-0.176px]">{{ $member['name'] }}</h4>
            @if ($member['category'])
                <p class="mt-1.5 text-xs font-normal leading-4 text-[#0E121B]">{{ $member['category'] }}</p>
            @endif
            @if (!empty($member['location']))
                <span class="flex gap-1.5 items-center my-1.5 text-xs font-medium leading-4 text-[#525866]">
                    <span class="flex justify-center items-center w-4 h-4">
                        <x-icon-location-pin />
                    </span>{{ $member['location'] }}
                </span>
            @endif
            <span class="flex gap-1.5 items-center my-1.5 text-xs font-medium leading-4 text-[#525866]">
                <x-icon-star-yellow />
                {{ $member['rating'] ?? '4.9' }} ({{ $member['total_rating_count'] ?? '320' }})
            </span>
        </div>
    </div>
    <div class="grid grid-cols-2 gap-3 mt-4">
        <a href="{{ $member['link'] }}" class="flex items-center justify-center font-medium text-sm tracking-[-0.096px] gap-2 bg-[#476CFF1A] border border-solid border-transparent text-[#335CFF] h-10 rounded-full transition-all duration-500 ease-in-out hover:bg-transparent hover:border-[#335CFF]">
            <x-icon-rigth-top-arrow />
            {{ __('View Profile') }}
        </a>
        <a href="tel:{{ $member['phone'] }}" class="flex items-center justify-center font-medium text-sm tracking-[-0.096px] gap-2 bg-[#335CFF] border border-solid border-[#335CFF] text-white h-10 rounded-full transition-all duration-500 ease-in-out hover:bg-[#1F3BAD]">
            <x-icon-phone-circle-outline />
            {{ __('Call') }}
        </a>
    </div>
</div>
