@props(['member', 'viewType' => 'list', 'memberType' => 'elite'])

@php
    // Profile image container sizing based on view type
    $imgContainerClass = 'relative border border-solid border-gray-1300 rounded-xl';
    $imgContainerClass .= $viewType === 'map' ? ' sm:w-[84px] w-[60px] sm:h-[84px] h-[60px]' : ' md:w-[106px] sm:w-20 w-[60px] md:h-[106px] sm:h-20 h-[60px]';
@endphp

<div class="{{ $imgContainerClass }}">
    <x-frontend.member.listing.partials.member-avatar-image :member="$member"
        class="object-cover object-center w-full h-full rounded-xl"
        alt="{{ $member->name }}" />

    @if ($memberType !== 'free')
        <span class="flex items-center absolute sm:-top-2.5 -top-1.5 sm:-right-3.5 -right-1.5">
            <x-icon-check-icon-secondary class="h-5 md:h-auto" />
        </span>
    @endif
</div>
