@props([
    'member' => null,
    'viewType' => 'list',
    'memberType' => 'elite',
    'buttonType' => 'profile', // profile, call, email
    'isMobile' => false,
    'href' => null,
])

@php
    // Generate button classes based on properties
    $primaryBtnClass = 'leading-5 font-bold inline-flex items-center justify-center rounded-lg transition-all duration-500 ease-in-out';
    $primaryBtnClass .= !$isMobile ? ($viewType === 'map' ? ' xl:text-[15px] text-[13px] h-10 xl:px-[25px] px-4' : ' text-[15px] h-10 px-[25px]') : ' text-[13px] w-full h-[36px]';

    // Button styles based on button type and member type
    if ($buttonType === 'profile') {
        if ($memberType === 'elite' || $memberType === 'free') {
            $btnClass = $primaryBtnClass . ' text-white bg-primary-blue hover:bg-blue-1300';
        } else {
            // Pro member
            $btnClass = $primaryBtnClass . ' text-primary-blue bg-transparent border border-solid border-primary-blue hover:bg-gray-1300';
        }
    } elseif ($buttonType === 'call') {
        if ($memberType === 'pro') {
            $btnClass = $primaryBtnClass . ' text-white bg-red-1300 hover:bg-red-1400';
        } else {
            $btnClass = $primaryBtnClass . ' text-white bg-red-1400 hover:bg-red-1300';
        }
    } elseif ($buttonType === 'email') {
        if ($memberType === 'elite' || $memberType === 'free') {
            $btnClass = $primaryBtnClass . ' text-white bg-primary-blue hover:bg-blue-1300';
        } else {
            // Pro member
            $btnClass = $primaryBtnClass . ' text-primary-blue bg-transparent border border-solid border-primary-blue hover:bg-gray-1300';
        }
    }
    // Merge with additional classes
    $buttonClass = $attributes->get('class') ? $btnClass . ' ' . $attributes->get('class') : $btnClass;
@endphp

<a class="{{ $buttonClass }}" {{ $attributes->merge(['href' => $href]) }}>
    {{ $slot }}
</a>
