@props(['member', 'memberType'])
@php
    if ($memberType == 'pro') {
        $buttonPrimaryClass = 'text-primary-blue hover:bg-gray-1300 border-primary-blue border border-solid bg-transparent';
        $buttonSecondaryClass = 'text-white hover:bg-red-1400 bg-red-1300';
    } else {
        $buttonPrimaryClass = 'text-white hover:bg-blue-1300 bg-primary-blue';
        $buttonSecondaryClass = 'text-white hover:bg-red-1300 bg-red-1400';
    }
@endphp

@if ($memberType == 'elite' || $memberType == 'pro')
    <ol {{ $attributes->merge(['class' => '']) }}>
        <li>
            <x-frontend.member.listing.partials.member-button-v1 url="{{ route('member.show', $member->slug) }}" :memberType="$memberType" class="h-10 px-[25px] text-[15px] {{ $buttonPrimaryClass }}">
                {{ __('Profile') }}
            </x-frontend.member.listing.partials.member-button-v1>
        </li>
        <li>
            <x-frontend.member.listing.partials.member-button-v1 :memberType="$memberType" url="#" class="h-10 px-[25px] text-[15px] {{ $buttonSecondaryClass }}">
                <span class="flex items-center group-hover:hidden call-us">{{ __('Call Us') }}</span>
                <span class="group-hover:flex hidden items-center gap-2.5 call-number-btn">
                    <x-icon-call-icon /> +1 (250) 123-4567 </span>
            </x-frontend.member.listing.partials.member-button-v1>

        </li>
        <li>
            <x-frontend.member.listing.partials.member-button-v1 :memberType="$memberType" data-modal-toggle="default-modal" url="#" class="h-10 px-[25px] text-[15px] {{ $buttonPrimaryClass }}">
                {{ __('Email') }}
            </x-frontend.member.listing.partials.member-button-v1>
        </li>
    </ol>
@endif
