@props(['member', 'memberType' => 'elite', 'isMobile' => false])

@php
    $categories = $member->parentCategories(5) ?? collect();
    $limit = $isMobile ? 1 : 3;
    $firstThree = $categories->take($limit);
    $hasMore = $categories->count() > $limit;
@endphp

@if ($isMobile)
    <ul class="flex items-center md:justify-start justify-center md:gap-3 sm:gap-1.5 gap-4 sm:mt-4 border-b border-t border-solid border-gray-1300">
        @forelse($firstThree as $category)
            <li class="my-1.5">
                <a href="#" class="lg:text-[15px] md:text-[13px] sm:text-[11px] text-[13px] font-semibold leading-[18px] tracking-[0.48px] text-gray-1500 underline inline-flex items-center justify-center">
                    @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                </a>
            </li>
            @if (!$loop->last)
                <li class="hidden sm:block">
                    <span class="w-px h-[23px] bg-gray-1600 flex items-center justify-center"></span>
                </li>
            @endif
        @empty
            <li class="my-1.5">
                <span class="lg:text-[15px] md:text-[13px] sm:text-[11px] text-[13px] font-semibold leading-[18px] tracking-[0.48px] text-gray-1500">
                    {{ __('No categories') }}
                </span>
            </li>
        @endforelse

        @if ($hasMore && $memberType !== 'free')
            <li class="my-1.5">
                <a href="#" class="text-[13px] font-normal text-gray-1500 flex items-center gap-2">
                    <x-icon-plus-icon2 />{{ __('More') }}
                </a>
            </li>
        @endif
    </ul>
@else
    <ul class="flex items-center 2xl:gap-3 gap-1.5 mt-3">
        @forelse($firstThree as $category)
            <li>
                <a href="#" class="2xl:text-[15px] md:text-[13px] text-[11px] font-semibold leading-[18px] tracking-[0.48px] text-gray-1500 underline inline-flex items-center justify-center">
                    {{-- {{ $category->category_name }} --}}
                    @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                </a>
            </li>
            @if (!$loop->last)
                <li><span class="w-px h-[23px] bg-gray-1600 flex items-center justify-center"></span></li>
            @endif
        @empty
            <li>
                <span class="2xl:text-[15px] md:text-[13px] text-[11px] font-semibold leading-[18px] tracking-[0.48px] text-gray-1500">
                    No categories
                </span>
            </li>
        @endforelse

        @if ($hasMore && $memberType !== 'free')
            <li><span class="w-px h-[23px] bg-gray-1600 flex items-center justify-center"></span></li>
            <li class="my-1.5">
                <a href="#" class="text-[13px] font-normal text-gray-1500 flex items-center gap-2">
                    <x-icon-plus-icon2 />{{ __('More') }}
                </a>
            </li>
        @endif
    </ul>
@endif
