@props(['member', 'mobile' => false])

@php
    $buttonClass = 'save-btn text-[13px] font-bold leading-5 text-primary-blue border border-solid border-gray-1600 rounded gap-2 inline-flex items-center justify-center';

    if ($mobile) {
        $buttonClass .= ' w-full text-xs h-7';
    } else {
        $buttonClass .= ' h-8 px-[13px]';
    }
@endphp

<a href="#" class="{{ $buttonClass }}">
    <svg width="{{ $mobile ? '12' : '15' }}"
        height="{{ $mobile ? '12' : '15' }}"
        viewBox="0 0 18 18"
        fill="none"
        xmlns="http://www.w3.org/2000/svg">
        <path d="M4 16V10H14V16H16V4.82843L13.1716 2H2V16H4ZM1 0H14L18 4V17C18 17.5523 17.5523 18 17 18H1C0.44772 18 0 17.5523 0 17V1C0 0.44772 0.44772 0 1 0ZM6 12V16H12V12H6Z" fill="#415B78" />
    </svg>
    {{ __('Save') }}
</a>
