@props(['type' => 'desktop', 'sort' => 'created-desc'])

@php
    $isDesktop = $type === 'desktop';
    $isMobile = $type === 'mobile';
    $radioName = $isDesktop ? 'default-radio' : 'mobile-sort-radio';
    $radioPrefix = $isDesktop ? 'default-radio' : 'mobile-radio';
@endphp

<ul class="{{ $isMobile ? 'space-y-3' : '' }}" {{ $isDesktop ? 'aria-labelledby=openSortDropdown' : '' }}>
    <li class="{{ $isDesktop ? 'mb-3' : '' }}">
        <div class="flex flex-row-reverse justify-between items-center py-2.5">
            <input id="{{ $radioPrefix }}-1" type="radio" wire:model.defer="sort" value="featured-first" checked="{{ $sort == 'featured-first' }}" name="{{ $radioName }}" class="w-[13px] h-[13px] text-blue-600 bg-white border border-solid border-gray-1200 shadow-9xl focus:ring-transparent focus:ring-0">
            <label for="{{ $radioPrefix }}-1" class="text-black-1200 flex-1 font-normal text-sm leading-5 tracking-[-0.096px]">{{ __('Featured First') }}</label>
        </div>
    </li>
    <li class="{{ $isDesktop ? 'mb-3' : '' }}">
        <div class="flex flex-row-reverse justify-between items-center py-2.5">
            <input id="{{ $radioPrefix }}-2" type="radio" wire:model.defer="sort" value="created-desc" checked="{{ $sort == 'created-desc' }}" name="{{ $radioName }}" class="w-[13px] h-[13px] text-blue-600 bg-white border border-solid border-gray-1200 shadow-9xl focus:ring-transparent focus:ring-0">
            <label for="{{ $radioPrefix }}-2" class="text-black-1200 flex-1 font-normal text-sm leading-5 tracking-[-0.096px]">{{ __('Most Recent') }}</label>
        </div>
    </li>
    <li class="{{ $isDesktop ? 'mb-3' : '' }}">
        <div class="flex flex-row-reverse justify-between items-center py-2.5">
            <input id="{{ $radioPrefix }}-3" type="radio" wire:model.defer="sort" value="rating-desc" checked="{{ $sort == 'rating-desc' }}" name="{{ $radioName }}" class="w-[13px] h-[13px] text-blue-600 bg-white border border-solid border-gray-1200 shadow-9xl focus:ring-transparent focus:ring-0">
            <label for="{{ $radioPrefix }}-3" class="text-black-1200 flex-1 font-normal text-sm leading-5 tracking-[-0.096px]">{{ __('Highest Rated') }}</label>
        </div>
    </li>
    <li class="{{ $isDesktop ? 'mb-3' : '' }}">
        <div class="flex flex-row-reverse justify-between items-center py-2.5">
            <input id="{{ $radioPrefix }}-4" type="radio" wire:model.defer="sort" value="rating-asc" checked="{{ $sort == 'rating-asc' }}" name="{{ $radioName }}" class="w-[13px] h-[13px] text-blue-600 bg-white border border-solid border-gray-1200 shadow-9xl focus:ring-transparent focus:ring-0">
            <label for="{{ $radioPrefix }}-4" class="text-black-1200 flex-1 font-normal text-sm leading-5 tracking-[-0.096px]">{{ __('Lowest Rated') }}</label>
        </div>
    </li>
</ul>
