@props(['viewType' => 'list'])
<div class="bg-gray-1400 rounded-full border border-solid border-gray-1200 px-1 py-[3px] grid grid-cols-2 gap-1">
    <button type="button" data-view-type="list" class="view-type-switch cursor-pointer {{ $viewType != 'map' ? 'text-black-1200 shadow-6xl rounded-full bg-white flex items-center px-[11px] py-1.5 justify-center gap-2.5 font-medium text-sm leading-5 tracking-[-0.096px]' : 'text-gray-1500 flex items-center px-[11px] py-1.5 justify-center gap-2.5 font-medium text-sm leading-5 tracking-[-0.096px]' }}">
        <x-icon-list-view />
        {{ __('List') }}
    </button>
    <button type="button" data-view-type="map" class="view-type-switch cursor-pointer {{ $viewType == 'map' ? 'text-black-1200 shadow-6xl rounded-full bg-white flex items-center px-[11px] py-1.5 justify-center gap-2.5 font-medium text-sm leading-5 tracking-[-0.096px]' : 'text-gray-1500 flex items-center px-[11px] py-1.5 justify-center gap-2.5 font-medium text-sm leading-5 tracking-[-0.096px]' }}">
        <x-icon-location-outline-v2 />
        {{ __('Map') }}
    </button>
</div>
