@props(['sponsoredItem'])
@php
    use Illuminate\Support\Str;
    $categories = $sponsoredItem->parentCategories(1) ?? collect();
@endphp
<div class="bg-white rounded-2xl shadow-7xl cursor-pointer hover:shadow-8xl transition-all duration-500 ease-in-out lg:p-6 md:p-4 px-5 py-6 mb-8 text-center border border-solid border-gray-1200">
    <a href="{{ route('member.show', $sponsoredItem->slug) }}">
        <div class="relative border border-solid border-gray-1200 mx-auto rounded-2xl w-[72px] p-2.5 h-[72px] flex items-center justify-center">
            <x-frontend.member.profile.partials.profile-avatar :user="$sponsoredItem" class="h-11 object-cover object-center" />
            @if ($sponsoredItem->membershipType->value != App\Enums\MembershipType::Free->value)
                @if ($sponsoredItem->isVerified())
                    <span class="flex items-center justify-center absolute md:-right-4 -right-3.5  md:-top-4 -top-3.5">
                        <x-icon-verify-icon />
                    </span>
                @endif
            @endif
        </div>
    </a>
    <a href="{{ route('member.show', $sponsoredItem->slug) }}">
        <h4 class="flex items-center justify-center gap-3 my-3  text-black-1200 font-medium lg:text-xl md:text-base text-xl leading-7">
            {{ $sponsoredItem->memberName() }}
            <span class="text-white font-medium text-xs leading-4 h-6 w-[67px] flex items-center justify-center border border-solid border-primary-blue bg-primary-blue rounded-full">{{ __('Featured') }}</span>
        </h4>
    </a>
    @if ($sponsoredItem->parentCategories(3)->isNotEmpty())
        <ul class="flex items-center gap-2 justify-center flex-wrap">
            @foreach ($sponsoredItem->parentCategories(3) as $category)
                <li><a href="{{ route('member.index', ['category' => $category->slug]) }}" class="tags">{{  Str::headline($category->category_name) }}</a></li>
            @endforeach
        </ul>
    @endif
    @if ($sponsoredItem->address())
        <p class="text-mid-gray font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center justify-center gap-1 mt-3">
            <span class="flex items-center justify-center w-5 h-5">
                <x-icon-location-outline-v2 />
            </span>
            <a href="{{ $sponsoredItem->mapUrl }}" target="_blank" class="transition-colors hover:text-primary-blue  hover:underline"">
                {{ Str::headline(str()->limit($sponsoredItem->address('short'), 50)) }}
            </a>
        </p>
    @endif
    <ul class="grid grid-cols-2 gap-3 mt-6">
        <li>
            <a href="{{ route('member.show', $sponsoredItem->slug) }}" class="view-btn">
                <x-icon-right-top-arrow />
                {{ __('View Profile') }}
            </a>
        </li>

        <li>
            <a href="tel:{{ $sponsoredItem->phone }}" class="primary-btn !bg-black-1200 !border-black-1200 text-white">
                <x-icon-phone-circle-outline />
                {{ __('Call') }}
            </a>
        </li>
    </ul>
</div>
