@props(['user'])
@php
    // Get business hours from the new table structure
    $businessHours = $user
        ->businessHours()
        ->orderByRaw(
            "
            CASE day_of_week
                WHEN 'monday' THEN 1
                WHEN 'tuesday' THEN 2
                WHEN 'wednesday' THEN 3
                WHEN 'thursday' THEN 4
                WHEN 'friday' THEN 5
                WHEN 'saturday' THEN 6
                WHEN 'sunday' THEN 7
            END
        ",
        )
        ->get();
    $seasonalHours = $user->profile?->getMeta('seasonal_hours') ?? [];

    // Function to convert time to 12-hour format
    function convertTo12Hour($time)
    {
        if (empty($time)) {
            return '';
        }

        if (strpos($time, ':') !== false) {
            $formatted = date('g:i A', strtotime($time));
            return $formatted;
        }

        return $time; // Return original if not a valid time format
    }
@endphp
@if ($businessHours->isNotEmpty() || $seasonalHours)
    <div class="py-12 border-b border-solid border-gray-1200">
        <div class="flex gap-3.5 items-center">
            <h6>{{ __('Business Hours') }}</h6>
            <span class="font-medium text-sm leading-5 whitespace-nowrap tracking-[-0.096px] text-gray-1500 flex items-center sm:gap-[5px] gap-[3px]">
                <x-icon-clock />
                {{ $user->profile?->getMeta('business_timezone') ?? config('app.timezone') }}
            </span>
        </div>
        <div class="mt-3 mb-5">
            <ul class="grid grid-cols-2 gap-1 p-1 rounded-full border border-solid bg-gray-1400 border-gray-1200"
                id="default-styled-tab2"
                data-tabs-toggle="#default-styled-tab-content2"
                data-tabs-active-classes="bg-white text-black-1200 shadow-6xl"
                data-tabs-inactive-classes="text-gray-1500 hover:text-black-1200 hover:bg-white hover:shadow-6xl"
                role="tablist">
                @if ($businessHours->isNotEmpty())
                    <li class="me-2" role="presentation">
                        <button class="inline-flex rounded-full h-8 items-center justify-center cursor-pointer w-full text-sm font-medium leading-5 tracking-[-0.096px] transition-all duration-500 ease-in-out"
                            id="Regular-styled-tab"
                            data-tabs-target="#styled-Regular"
                            type="button"
                            role="tab"
                            aria-controls="Regular"
                            aria-selected="false">{{ __('Regular') }}</button>
                    </li>
                @endif
                @if ($seasonalHours)
                    <li class="me-2" role="presentation">
                        <button class="inline-flex items-center h-8 rounded-full justify-center cursor-pointer text-sm w-full font-medium leading-5 tracking-[-0.096px] transition-all duration-500 ease-in-out"
                            id="Seasonal-styled-tab"
                            data-tabs-target="#styled-Seasonal"
                            type="button"
                            role="tab"
                            aria-controls="Seasonal"
                            aria-selected="false">{{ __('Seasonal') }}</button>
                    </li>
                @endif
            </ul>
        </div>
        <div id="default-styled-tab-content2">
            @if ($businessHours->isNotEmpty())
                <div class="hidden"
                    id="styled-Regular"
                    role="tabpanel"
                    aria-labelledby="Regular-tab">
                    <div class="grid grid-cols-1 gap-4 mt-5 lg:grid-cols-2">
                        @foreach ($businessHours as $businessHour)
                            <div class="flex gap-1.5 items-center p-4 rounded-2xl border border-solid border-gray-1200">
                                <span class="flex justify-center items-center w-10 h-10">
                                    @if ($businessHour->is_open)
                                        <x-icon-calendar-open />
                                    @else
                                        <x-icon-calendar-close />
                                    @endif
                                </span>
                                <div class="flex-1 w-full">
                                    <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">
                                        {{ $businessHour->day_of_week->getLabel() }}
                                        @if ($businessHour->hours_label)
                                            <span class="ml-2 text-xs text-gray-500">({{ $businessHour->hours_label }})</span>
                                        @endif
                                    </span>
                                    <span class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-black-1200 mt-1.5">
                                        @if (!$businessHour->is_open)
                                            {{ __('Closed') }}
                                        @else
                                            {{ convertTo12Hour($businessHour->open_time) }} - {{ convertTo12Hour($businessHour->close_time) }}
                                        @endif
                                    </span>
                                </div>
                            </div>
                        @endforeach
                    </div>

                </div>
            @endif

            @if ($seasonalHours)
                <div class="hidden"
                    id="styled-Seasonal"
                    role="tabpanel"
                    aria-labelledby="Seasonal-tab">
                    <div class="grid grid-cols-1 gap-4 mt-5 lg:grid-cols-2">
                        @foreach ($seasonalHours as $seasonalHour)
                            <div class="flex gap-1.5 rounded-2xl border border-solid border-gray-1200 p-4">
                                <span class="flex justify-center items-center w-10 h-10">
                                    @if ($seasonalHour['is_open'])
                                        <x-icon-calendar-open />
                                    @else
                                        <x-icon-calendar-close />
                                    @endif
                                </span>
                                <div class="flex-1 w-full ">
                                    <div class="flex flex-col gap-2">
                                        @if ($seasonalHour['season_name'])
                                            <span class="flex items-center font-medium text-base tracking-[-0.096px] leading-5 text-black-1200">
                                                {{ $seasonalHour['season_name'] }}
                                                <span class="ml-2 text-xs text-gray-500">
                                                    ({{ \Carbon\Carbon::parse($seasonalHour['start_date'])->format('j M Y') }} - {{ \Carbon\Carbon::parse($seasonalHour['end_date'])->format('j M Y') }})
                                                </span>
                                            </span>
                                        @endif
                                        
                                        @foreach ($seasonalHour['seasonal_days_with_hours'] as $dayGroup)
                                            <div class="flex flex-col">
                                                <span class="font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">
                                                    {{ $dayGroup['day'] }}
                                                </span>
                                                <span class="font-medium text-base tracking-[-0.176px] leading-6 text-black-1200">
                                                    @if (!$seasonalHour['is_open'])
                                                        {{ __('Closed') }}
                                                    @else
                                                        {{ convertTo12Hour($dayGroup['start_time']) }} - {{ convertTo12Hour($dayGroup['end_time']) }}
                                                    @endif
                                                </span>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
        @if ($user->profile?->getMeta('emergency_service_enabled'))
            <div class="flex gap-1.5 items-center p-4 mt-4 bg-white rounded-2xl border border-solid border-gray-1200">
                <span class="flex justify-center items-center w-10 h-10">
                    <x-icon-phone-black />
                </span>
                <div class="flex-1 w-full">
                    <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">
                        {{ $user->profile?->getMeta('emergency_service_title') ?? '24/7 Emergency Services (Available outside regular business hours for urgent water system issue)' }}
                    </span>
                    <span class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-red-1400 mt-1.5 gap-2">
                        {{ __('Call us at') }}
                        @if ($user->profile?->phone)
                            <a href="tel:{{ $user->profile->phone }}" class="underline text-primary-blue">{{ $user->profile->phone }}</a>
                        @else
                            <a href="#" class="underline text-primary-blue">{{ $user->profile?->getMeta('emergency_phone') ?? '250-391-3969' }}</a>
                        @endif
                    </span>
                </div>
            </div>
        @endif
    </div>
@endif
