@props(['user'])
@php
    $name = $user->profile?->company_name ?? $user->name;
    $phone = $user->profile?->phone ?? null;
    $email = $user->email ?? null;
    $website = $user->profile?->website ?? null;
    $fax = $user->profile?->fax ?? null;
    $mobile = $user->profile?->mobile ?? null;
    $location = $user->primaryLocation ? $user->primaryLocation : null;
    $address = $user->address();
    $category = $user->parentCategories(1)->first();
    $mapUrl = $user->mapUrl;
    $average_rating = $reviewsStats['average_rating'] ?? 0;
    $rating_count = $reviewsStats['total_reviews'] ?? 0;
    $mapIframeUrl = $user->mapIframeUrl();
@endphp
<div class="py-12 border-b border-solid border-gray-1200">
    <h6>Contact {{ $name }}</h6>
    <div class="grid grid-cols-1 gap-4 mt-5 lg:grid-cols-2">
        @if ($phone)
            <div class="flex gap-1.5 items-center p-4 rounded-2xl border border-solid border-gray-1200">
                <span class="flex justify-center items-center w-10 h-10">
                    <x-icon-phone-black class="w-6 h-6" />
                </span>
                <div class="flex-1 w-full">
                    <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">Phone</span>
                    <a href="tel:{{ $phone }}" class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-black-1200 mt-1.5">{{ $phone }}</a>
                </div>
            </div>
        @endif
        {{-- @if ($address)
            <div class="flex gap-1.5 items-center p-4 rounded-2xl border border-solid border-gray-1200">
                <span class="flex justify-center items-center w-10 h-10">
                    <x-icon-location-outline class="w-6 h-6" />
                </span>
                <div class="flex-1 w-full">
                    <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">Address</span>
                    <a href="{{ $user->mapUrl }}"
                        target="_blank"
                        class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-black-1200 mt-1.5">{{ $address }}</a>
                </div>
            </div>
        @endif --}}
        @if ($website)
            <div class="flex gap-1.5 items-center p-4 rounded-2xl border border-solid border-gray-1200">
                <span class="flex justify-center items-center w-10 h-10">
                    <x-icon-global />
                </span>
                <div class="flex-1 w-full">
                    <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">{{ __('Website') }}</span>
                    <a href="{{ $website }}"
                        target="_blank"
                        class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-black-1200 mt-1.5">{{ $website }}</a>
                </div>
            </div>
        @endif
        @if (!empty($email))
            <div class="flex gap-1.5 items-center p-4 rounded-2xl border border-solid border-gray-1200">
                <span class="flex justify-center items-center w-10 h-10">
                    <x-icon-email-icon />
                </span>
                <div class="flex-1 w-full">
                    <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">{{ __('Email') }}</span>
                    <a href="javascript:void(0)" onclick="Livewire.dispatch('openModal', { component: 'frontend.member.modal.member-contact-modal', arguments: { member: '{{ $user->slug }}' }})" class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-black-1200 mt-1.5">
                        {{ esp_mask_email($email) }}
                    </a>
                </div>
            </div>
        @endif
    </div>

    @if ($address)
        <div class="block mt-12 md:hidden">
            <h6>{{ __('Our Address') }}</h6>
            <a href="{{ $user->mapUrl }}" >
            <p class="mt-1.5 mb-5 text-mid-gray text-base font-normal leading-6">{{ $address }}</p>
            </a>
            @if ($mapIframeUrl)
                <iframe width="100%"
                    height="200"
                    frameborder="0"
                    style="border:0;"
                    class="w-full rounded-xl"
                    referrerpolicy="no-referrer-when-downgrade"
                    src="{{ $mapIframeUrl }}"
                    allowfullscreen>
                </iframe>
            @endif
        </div>
    @endif
</div>
