@props(['user'])
@php
    use App\Enums\ProfessionalCredentionals;
    $credentials = $user->profile?->credentials ?? [];

    $awards = $user->profile?->getMeta('awards_recognitions') ?? [];
@endphp

@if (!empty($credentials) || !empty($awards))
    @if (!empty($credentials))
        <!-- Certifications Section -->
        <div class="py-12 border-b border-solid border-gray-1200">
            <h6>{{ __('Certifications') }}</h6>
            <div class="grid grid-cols-1 gap-4 mt-5 lg:grid-cols-2">
                @foreach ($credentials as $credential)
                    @if (!empty($credential['credential_value']))
                        <div class="flex gap-1.5 items-center p-4 rounded-2xl bg-gray-1400">
                            @if (!empty($credential['credential_type']))
                                <span class="flex justify-center items-center w-10 h-10">
                                    <x-dynamic-component :component="ProfessionalCredentionals::from($credential['credential_type'])->getIcon()" class="w-6 h-6" />
                                </span>
                            @endif
                            <div class="flex-1 w-full">
                                @if (!empty($credential['credential_type']))
                                    <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">
                                        {{ ProfessionalCredentionals::from($credential['credential_type'])->getLabel() }}
                                    </span>
                                @endif
                                <p class="flex items-center font-medium text-sm tracking-[-0.096px] leading-6 text-black-1200">
                                    {{ $credential['credential_value'] }}
                                </p>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    @endif

    @if (!empty($awards))
        <!-- Awards & Recognition Section -->
        <div class="py-12 border-b border-solid border-gray-1200">
            <h6>{{ __('Awards & Recognition') }}</h6>
            <div class="grid grid-cols-1 gap-4 mt-5 lg:grid-cols-2">
                @foreach ($awards as $award)
                    <div class="flex gap-1.5 items-center p-4 rounded-2xl bg-gray-1400">
                        <span class="flex justify-center items-center w-10 h-10">
                            <x-icon-trophy-line />
                        </span>
                        <div class="flex-1 w-full">
                            <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">{{ $award['year'] ?? '2023' }}</span>
                            <p class="flex items-center font-medium text-sm tracking-[-0.096px] leading-6 text-black-1200">
                                {!! $award['title'] !!}
                            </p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    @endif
@endif
