@props(['user'])
@php
    use Illuminate\Support\Str;
    // Decode and strip HTML tags
    $plainDescription = strip_tags(html_entity_decode($user->profile?->about, ENT_QUOTES | ENT_HTML5, 'UTF-8'));

    // Limit for preview - approx 300 characters to simulate 3 lines
    $preview = Str::limit($plainDescription, 300);
@endphp
@if ($user->profile?->about)
    <div class="pb-12 border-b border-solid border-gray-1200">
        <h6>{{ $user->memberName() }} {{ __('Overview') }}</h6>
        <div x-data="{ expanded: false }" class="article-content max-w-[800px] w-full lg:text-base md:text-sm text-base font-normal leading-6 text-mid-gray mt-3">
            <div x-show="!expanded">
                {!! $preview !!}
            </div>
            <div x-show="expanded" class="overflow-hidden transition-all duration-500 ease-in-out">
                {!! $user->profile?->about !!}
            </div>

            @if (strlen($user->profile?->about) > 300)
                <button @click="expanded = !expanded" class="mt-5 readmore-btn flex items-center gap-1 transition-all duration-300 text-black">
                    <span x-text="expanded ? 'Show less' : 'Read more'" class="transition-all duration-300"></span>
                    <svg width="11"
                        height="7"
                        viewBox="0 0 11 7"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                        :class="expanded ? 'rotate-180' : ''"
                        class="transform transition-transform duration-500 ease-in-out">
                        <path d="M5.49999 4.54697L9.21249 0.834473L10.273 1.89497L5.49999 6.66797L0.72699 1.89497L1.78749 0.834473L5.49999 4.54697Z" fill="#525866" />
                    </svg>
                </button>
            @endif
        </div>
    </div>
@endif
