@php
    $emergencyServiceTitle = $user->profile?->getMeta('emergency_service_title');
    $emergencyServiceDescription = $user->profile?->getMeta('emergency_service_description');
    $emergencyServiceNumber = $user->profile?->getMeta('emergency_service_number');
@endphp
<span class="flex items-center justify-center w-5 h-5 sm:w-6 sm:h-6"><x-icon-info-icon /></span>
<div class="relative flex-1 w-full border-l border-solid border-red-1400/[0.3] sm:pl-4 pl-3 sm:ml-4 ml-3">
    <h4 class="sm:text-base text-sm font-bold leading-[130%] text-primary-blue sm:mb-2 mb-1">
        {{ $emergencyServiceTitle }}
    </h4>
    <p class="font-normal sm:text-base text-[13px] leading-[130%] text-gray-1500 mb-3">
        {{ $emergencyServiceDescription }}
    </p>
    <a href="tel:{{ $emergencyServiceNumber }}" class="inline-flex items-center text-gray-1500 sm:text-base text-[13px] font-bold gap-2.5 bg-gray-1400 rounded-[100px] sm:h-[37px] h-[33px] sm:px-[17px] px-4"><x-icon-phone-icon2 class="h-4 sm:h-auto" /> {{ $emergencyServiceNumber }}</a>
</div>
