@props(['user'])

@php
    $faqs = $user->getFaqs();
@endphp
<!----- FAQ SEC ------>
@if (!empty($faqs))
    <section class="py-12 border-b border-solid border-gray-1200">
        <div class="max-w-[1232px] w-full">
            <div class="">
                <h3 class="flex-wrap text-[20px] text-black-1200 font-medium leading-[28px]tracking-[-0.32px]">
                    {{ __('Frequently Asked Questions') }}
                </h3>
            </div>
            <div class="max-w-[720px] w-full mt-8">
                <div id="accordion-collapse" data-accordion="collapse">
                    @foreach ($faqs as $key => $faq)
                        <div class="p-4 mb-4 rounded-2xl border border-solid border-gray-1200">
                            <h2 id="accordion-collapse-heading-{{ $key }}">
                                <button type="button"
                                    class="flex items-center justify-between gap-3 cursor-pointer w-full  !text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px] focus:ring-0 focus:ring-transparent"
                                    data-accordion-target="#accordion-collapse-body-{{ $key }}"
                                    aria-expanded="false"
                                    aria-controls="accordion-collapse-body-{{ $key }}">
                                    <p class="flex-1 pr-3 text-start text-balance">{{ $faq['question'] }}</p>
                                    <span class="flex justify-center items-center w-8 h-8 md:w-8 md:h-8 rounded-full bg-gray-1400 flex-none shrink-0">
                                        <svg data-accordion-icon
                                            class="w-3 h-3 rotate-180 shrink-0"
                                            aria-hidden="true"
                                            xmlns="http://www.w3.org/2000/svg"
                                            fill="none"
                                            viewBox="0 0 10 6">
                                            <path stroke="#525866"
                                                stroke-linecap="round"
                                                stroke-linejoin="round"
                                                stroke-width="2"
                                                d="M9 5 5 1 1 5" />
                                        </svg>
                                    </span>
                                </button>
                            </h2>
                            <div id="accordion-collapse-body-{{ $key }}"
                                class="hidden"
                                aria-labelledby="accordion-collapse-heading-{{ $key }}">
                                <div class="mt-2 text-base font-normal leading-6 text-mid-gray">
                                    {{-- <p class="text-base font-normal leading-6 text-mid-gray"> --}}
                                    {!! $faq['answer'] !!}
                                    {{-- </p> --}}
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endif
