@props(['user'])
@php
    $gallery = $user->getMedia('gallery');
    $totalImages = $gallery->count();
@endphp

{{-- @if ($totalImages > 0)
    <!-- Desktop Gallery (hidden on mobile, shows on md+) -->
    <div class="hidden grid-cols-2 gap-2.5 md:grid" id="profile-gallery">
        <!-- Large image on left -->
        <div class="">
            <a href="{{ $gallery->first()->getUrl() }}"
                class="flex justify-center items-center h-full profile-gallery-item"
                data-src="{{ $gallery->first()->getUrl() }}"
                data-sub-html="{{ $gallery->first()->name ?? 'Gallery Image' }}">
                <img src="{{ $gallery->first()->getUrl('medium') }}"
                    alt="{{ $gallery->first()->name ?? 'Gallery Image' }}"
                    class="object-cover object-center w-full h-full rounded-xl"
                    loading="lazy" />
            </a>
        </div>

        <!-- 4 smaller images on right in 2x2 grid -->
        <div class="grid grid-cols-2 gap-2.5">
            @for ($i = 1; $i < 5; $i++)
                @if ($i < $totalImages)
                    @php $image = $gallery->skip($i)->first(); @endphp
                    @if ($i == 4 && $totalImages > 5)
                        <!-- Last image with "Show all photos" overlay -->
                        <div class="relative">
                            <a href="{{ $image->getUrl() }}"
                                class="flex justify-center items-center h-full profile-gallery-item"
                                data-src="{{ $image->getUrl() }}"
                                data-sub-html="{{ $image->name ?? 'Gallery Image' }}">
                                <img src="{{ $image->getUrl('thumb') }}"
                                    alt="{{ $image->name ?? 'Gallery Image' }}"
                                    class="object-cover object-center w-full h-full rounded-xl"
                                    loading="lazy" />
                            </a>
                            <button onclick="window.openProfileGallery()" class="absolute right-4 bottom-4 flex items-center justify-center text-black font-medium text-sm leading-5 tracking-[-0.096px] gap-2.5 rounded-lg bg-white/[0.9] shadow-4xl h-9 max-w-[153px] w-full hover:bg-white transition-all cursor-pointer">
                                <img src="{{ theme_asset('img/grid-icon.svg') }}" alt="" />
                                {{ __('Show all photos') }}
                            </button>
                        </div>
                    @else
                        <!-- Regular image -->
                        <div class="">
                            <a href="{{ $image->getUrl() }}"
                                class="flex justify-center items-center h-full profile-gallery-item"
                                data-src="{{ $image->getUrl() }}"
                                data-sub-html="{{ $image->name ?? 'Gallery Image' }}">
                                <img src="{{ $image->getUrl('thumb') }}"
                                    alt="{{ $image->name ?? 'Gallery Image' }}"
                                    class="object-cover object-center w-full h-full rounded-xl"
                                    loading="lazy" />
                            </a>
                        </div>
                    @endif
                @else
                    <!-- Placeholder if less than 5 images -->
                    <div class=""></div>
                    <div class=""></div>
                @endif
            @endfor
        </div>

        <!-- Hidden images for lightbox (remaining images after first 5) -->
        @if ($totalImages > 5)
            <div class="hidden">
                @foreach ($gallery->skip(5) as $image)
                    <a href="{{ $image->getUrl() }}"
                        class="profile-gallery-item"
                        data-src="{{ $image->getUrl() }}"
                        data-sub-html="{{ $image->name ?? 'Gallery Image' }}">
                        <img src="{{ $image->getUrl('thumb') }}"
                            alt="{{ $image->name ?? 'Gallery Image' }}"
                            class="hidden"
                            loading="lazy" />
                    </a>
                @endforeach
            </div>
        @endif
    </div>

    <!-- Mobile Gallery (shows only on mobile) -->
    <div class="block mt-8 md:hidden">
        <div class="swiper gallerySwiper">
            <div class="swiper-wrapper">
                @foreach ($gallery as $image)
                    <div class="swiper-slide">
                        <a href="{{ $image->getUrl() }}" class="flex justify-center items-center">
                            <img src="{{ $image->getUrl('thumb') }}"
                                alt="{{ $image->name ?? 'Gallery Image' }}"
                                class="w-full h-[280px] object-center object-cover"
                                loading="lazy" />
                        </a>
                    </div>
                @endforeach
            </div>
            <div class="swiper-pagination text-xs font-medium leading-4 text-black h-6 rounded-lg bg-gray-1500/[0.24] inline-flex items-center justify-center px-4 bottom-3 right-3 !left-auto !w-auto">
            </div>
            <div class="swiper-button-next bg-white text-black !w-8 !h-8 rounded-full flex items-center justify-center after:hidden">
                <x-icon-right-arrow-v2 />
            </div>
            <div class="swiper-button-prev bg-white text-black !w-8 !h-8 rounded-full flex items-center justify-center after:hidden">
                <x-icon-left-arrow-v2 />
            </div>
        </div>
    </div>
@endif --}}
@if ($totalImages > 0)
    <div class="flex md:flex-row flex-col items-start gap-2.5 md:px-0 px-6">
        <div class="md:w-[calc(100%-134px)] w-full">
            <div class="relative">
                <div class="swiper gallerySwiper">
                    <div class="swiper-wrapper">
                        @foreach ($gallery as $image)
                            <div class="swiper-slide">
                                <img src="{{ $image->getUrl('medium') }}"
                                    alt="{{ $image->name ?? 'Gallery Image' }}"
                                    class="w-full md:h-[416px] h-[330px] object-center object-cover rounded-xl" />
                            </div>
                        @endforeach
                    </div>
                </div>

                <div class="swiper-pagination swiper-pagination23"></div>
                <div class="gallerySwiper-btn">
                    <div class="swiper-button-next after:hidden m-0! top-1/2! -translate-y-1/2! rounded-full w-8! h-8! flex items-center justify-center">
                        <x-icon-swiper-right-v1 class="text-white" />
                    </div>
                    <div class="swiper-button-prev after:hidden m-0! top-1/2! -translate-y-1/2! rounded-full w-8! h-8! flex items-center justify-center">
                        <x-icon-swiper-left-v1 class="text-white" />
                    </div>
                </div>
            </div>
        </div>
        <div class="md:block grid grid-cols-4 md:gap-0 gap-1 md:max-w-[134px] max-w-full w-full">
            @for ($i = 0; $i < min(4, $gallery->count()); $i++)
                @php $image = $gallery->get($i); @endphp
                @if ($i < 3)
                    <div class="md:mb-2.5 mb-0">
                        {{-- <a href="{{ $image->getUrl() }}" class="flex items-center justify-center"> --}}
                        <img src="{{ $image->getUrl('thumb') }}"
                            alt="{{ $image->name ?? 'Gallery Image' }}"
                            class="w-full md:h-[96.5px] h-[76px] object-center object-cover rounded-xl" />
                        {{-- </a> --}}
                    </div>
                @else
                    <div class="relative">
                        {{-- <a href="" class="flex items-center justify-center"> --}}
                        <img src="{{ $gallery[$i]->getUrl('thumb') }}"
                            alt="{{ $gallery[$i]->name ?? 'Gallery Image' }}"
                            class="w-full md:h-[96.5px] h-[76px] object-center object-cover rounded-xl" />
                        {{-- </a> --}}
                        <div class="absolute left-0 top-0 flex items-center justify-center text-white font-semibold text-2xl leading-6 tracking-[-0.24px] rounded-xl bg-black-1200/[0.56] h-full w-full">
                            +{{ $gallery->count() - 4 }}
                        </div>
                    </div>
                @endif
            @endfor

        </div>
    </div>
@endif
