@props(['user', 'reviewsStats' => []])
@php
    use Illuminate\Support\Str;
    $average_rating = $reviewsStats['average_rating'] ?? 0;
    $rating_count = $reviewsStats['total_reviews'] ?? 0;
    $isFree = $user->membershipType->value == App\Enums\MembershipType::Free->value;
    $serviceAreas = $user->profile?->service_areas ?? [];
    $categories = $user->parentCategories(3);
@endphp
<div class="max-w-[1310px] w-full  mx-auto md:px-4 px-6">
    <div class="flex relative flex-col justify-between items-center lg:flex-row">
        <div class="flex flex-col flex-1 gap-3 items-start w-full md:flex-row md:gap-6">
            <div class="relative">
                <div class="relative bg-white border border-solid border-gray-1200 rounded-2xl md:w-[100px] p-2.5 w-20 md:h-[100px] h-20 flex items-center justify-center">
                    <x-frontend.member.profile.partials.profile-avatar :user="$user" />
                    @if ($user->membershipType->value != App\Enums\MembershipType::Free->value)
                        @if ($user->isVerified())
                            <span class="flex absolute -top-3.5 -right-3.5 justify-center items-center md:-right-4 md:-top-4">
                                <x-icon-verify-icon />
                            </span>
                        @endif
                    @endif
                </div>
            </div>
            <div>
                <h4 class="flex gap-3 items-center text-2xl font-medium leading-8 text-black-1200">
                    {{ $user->memberName() }}
                    @if ($user->membershipType->value !== App\Enums\MembershipType::Free->value)
                        <span class="inline-flex items-center justify-center font-medium text-xs border border-solid border-primary-blue bg-blue-1200 pr-2 pl-1 text-primary-blue gap-[2px] rounded-full h-6">
                            <span class="w-4 h-4 flex items-center justify-center">
                                <x-icon-flashlight class="w-4 h-4" />
                            </span>
                            {{ $user->membershipType->getLabel() }}
                        </span>
                    @endif
                </h4>
                @if (!empty($user->profile->slogan))
                    <p class="font-medium md:text-base text-sm leading-6 tracking-[-0.176px] text-mid-gray mt-1">
                        {{ Str::headline(str()->limit($user->profile->slogan, 100)) }}
                    </p>
                @endif

                @if ($user->parentCategories(3)->isNotEmpty())
                    <ul class="flex flex-wrap gap-2 items-center mt-3 md:flex-nowrap">
                        @foreach ($user->parentCategories(3) as $category)
                            <li>
                                <a href="{{ route('member.index', ['category' => $category->slug]) }}" class="tags">
                                    @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                                </a>
                            </li>
                        @endforeach

                    </ul>
                @endif
                <div class="flex flex-col items-start mt-3 md:flex-row md:items-center md:mt-4">
                    @if ($rating_count > 0)
                        <ul class="flex items-center gap-[5px]">
                            <x-frontend.review.partials.review-average-star-yellow :rating="$average_rating" />
                            <li class="ml-1.5">
                                <a href="javascript:void(0)"
                                    onclick="document.getElementById('profile-reviews-styled-tab').click()"
                                    class="flex items-center font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] text-mid-gray underline underline-offset-2">
                                    {{ $rating_count }} {{ Str::headline('reviews') }}
                                </a>
                            </li>
                        </ul>
                    @endif
                    @if ($user->address() || !empty($user->profile->year_established))
                        <ul class="flex flex-col items-start mt-3 md:flex-row md:items-center {{ $rating_count > 0 ? 'md:ml-2' : '' }} md:mt-0">
                            @if ($user->address())
                                <li class="text-mid-gray md:mb-0 mb-2 font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:pr-2 {{ $rating_count > 0 ? 'md:border-l border-solid border-gray-1200 md:pl-2' : '' }}">
                                    <span class="flex justify-center items-center w-5 h-5">
                                        <x-icon-location-outline-v2 class="w-4 h-4" />
                                    </span>
                                    <a href="{{ $user->mapUrl }}"
                                        target="_blank"
                                        class="cursor-pointer transition-colors hover:text-primary-blue">
                                        {{ Str::headline(str()->limit($user->address('short'), 50)) }}
                                    </a>
                                </li>
                            @endif
                            @if (!empty($user->profile->year_established))
                                <li class="text-mid-gray font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:pl-2 {{ !empty($user->address()) ? 'md:border-l border-solid border-gray-1200 md:pr-2' : '' }}">
                                    <span class="flex justify-center items-center w-5 h-5">
                                        <x-icon-business-icon class="w-4 h-4" />
                                    </span>

                                    {{ Str::headline(__('In Business since')) }} {{ $user->profile->year_established }}
                                </li>
                            @endif
                        </ul>
                    @endif
                </div>
            </div>
        </div>
        @if ($user->membershipType->value !== App\Enums\MembershipType::Free->value)
            <div class="xl:max-w-[321px] lg:max-w-[200px] max-w-full w-full lg:mt-0 mt-6">
                <div class="mb-3">
                    <ul class="flex md:justify-end items-center">
                        <li>
                            {{-- <a href="#" class="group flex items-center justify-center text-sm font-medium tracking-[-0.084px] leading-5 text-mid-gray gap-3">
                                Share
                                <span class="flex items-center rounded-full justify-center bg-white border border-solid border-gray-1200 w-10 h-10">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                        width="17"
                                        height="9"
                                        viewBox="0 0 17 9"
                                        fill="none">
                                        <path d="M12.5 0H9.16667V1.66667H12.5C13.875 1.66667 15 2.79167 15 4.16667C15 5.54167 13.875 6.66667 12.5 6.66667H9.16667V8.33333H12.5C14.8 8.33333 16.6667 6.46667 16.6667 4.16667C16.6667 1.86667 14.8 0 12.5 0ZM7.5 6.66667H4.16667C2.79167 6.66667 1.66667 5.54167 1.66667 4.16667C1.66667 2.79167 2.79167 1.66667 4.16667 1.66667H7.5V0H4.16667C1.86667 0 0 1.86667 0 4.16667C0 6.46667 1.86667 8.33333 4.16667 8.33333H7.5V6.66667ZM5 3.33333H11.6667V5H5V3.33333Z" fill="#525866" />
                                    </svg>
                                </span>
                            </a> --}}
                            <x-frontend.includes.share-modal-button :user="$user"
                                url="{{ $user->permalink }}"
                                target="share-modal"
                                toggle="share-modal"
                                type="profile"
                                class="group flex items-center justify-center text-sm font-medium tracking-[-0.084px] leading-5 text-mid-gray gap-3">
                                {{ __('Share') }}
                                <span class="flex items-center rounded-full justify-center bg-white border border-solid border-gray-1200 w-10 h-10">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                        width="17"
                                        height="9"
                                        viewBox="0 0 17 9"
                                        fill="none">
                                        <path d="M12.5 0H9.16667V1.66667H12.5C13.875 1.66667 15 2.79167 15 4.16667C15 5.54167 13.875 6.66667 12.5 6.66667H9.16667V8.33333H12.5C14.8 8.33333 16.6667 6.46667 16.6667 4.16667C16.6667 1.86667 14.8 0 12.5 0ZM7.5 6.66667H4.16667C2.79167 6.66667 1.66667 5.54167 1.66667 4.16667C1.66667 2.79167 2.79167 1.66667 4.16667 1.66667H7.5V0H4.16667C1.86667 0 0 1.86667 0 4.16667C0 6.46667 1.86667 8.33333 4.16667 8.33333H7.5V6.66667ZM5 3.33333H11.6667V5H5V3.33333Z" fill="#525866" />
                                    </svg>
                                </span>
                            </x-frontend.includes.share-modal-button>
                        </li>
                    </ul>
                </div>
                <div class="block">
                    @if (!empty($user->profile?->phone))
                        <a href="tel:{{ $user->profile?->phone }}" class="mb-3 primary-btn-large">
                            <x-icon-phone-icon class="w-4 h-4" />
                            {{ __('Call Now') }}
                        </a>
                    @endif
                    @if (!empty($user->email))
                        <x-frontend.includes.contact-modal-button :user="$user" class="secondary-btn h-[52px]!">
                            <x-icon-chat-icon-blue class="w-4 h-4" /> {{ __('Message us') }}
                        </x-frontend.includes.contact-modal-button>
                    @endif
                </div>
            </div>
        @endif
    </div>
</div>
{{--
<div class="max-w-[1310px] w-full mx-auto md:px-4 px-6">
    <div class="flex relative flex-col justify-between items-center lg:flex-row">
        <div class="flex flex-col flex-1 gap-3 items-start w-full md:flex-row md:gap-6">
            <div class="relative">
                <div class="relative border border-solid border-gray-1200 rounded-2xl md:w-[100px] p-2.5 w-20 md:h-[100px] h-20 flex items-center justify-center">
                    <x-frontend.member.profile.partials.profile-avatar :user="$user" />
                    @if ($user->membershipType->value != App\Enums\MembershipType::Free->value)
                        @if ($user->isVerified())
                            <span class="flex absolute -top-3.5 -right-3.5 justify-center items-center md:-right-4 md:-top-4">
                                <x-icon-verify-icon />
                            </span>
                        @endif
                    @endif
                </div>
            </div>
            <div>
                <h4 class="flex gap-3 items-center text-2xl font-medium leading-8 text-black-1200">
                    {{ $user->memberName() }}
                    @if ($user->membershipType->value !== App\Enums\MembershipType::Free->value)
                        <span class="inline-flex items-center justify-center font-medium text-xs border border-solid border-primary-blue bg-blue-1200 px-[7px] text-primary-blue gap-[5px] rounded-full h-6">
                            <x-icon-flashlight class="w-4 h-4" />
                            {{ $user->membershipType->getLabel() }}
                        </span>
                    @endif
                </h4>

                @if (!empty($user->profile->slogan))
                    <p class="font-medium md:text-base text-sm leading-6 tracking-[-0.176px] text-mid-gray mt-1">
                        {{ Str::headline(str()->limit($user->profile->slogan, 100)) }}
                    </p>
                @endif

                @php
                    $categories = $user->parentCategories(3);
                @endphp

                @if ($categories->isNotEmpty())
                    <ul class="flex flex-wrap gap-2 items-center mt-3 md:flex-nowrap">
                        @foreach ($categories as $category)
                            <li>
                                <a class="tags">
                                    @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                                </a>
                            </li>
                        @endforeach
                    </ul>
                @endif

                <div class="flex flex-col items-start mt-3 md:flex-row md:items-center md:mt-4">
                    @if ($rating_count > 0)
                        <div class="flex items-center mr-4">
                            <x-frontend.review.partials.review-average-star-yellow :rating="$average_rating" />
                            <a onclick="document.getElementById('profile-reviews-styled-tab').click()" class="cursor-pointer flex items-center font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] text-mid-gray underline underline-offset-2 ml-2">
                                {{ $rating_count }} {{ Str::headline('reviews') }}
                            </a>
                            <!-- @else
                            <a class="flex items-center font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] text-mid-gray">
                                {{ Str::headline('No reviews') }}
                            </a> -->
                        </div>
                    @endif
                    <ul class="flex flex-col items-start mt-2 md:flex-row md:items-center md:mt-0 {{ $rating_count > 0 ? 'md:ml-2' : '' }}">
                        @if ($user->address())
                            <li class="text-mid-gray md:mb-0 mb-2 font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:pr-2 {{ $rating_count > 0 ? 'md:border-l border-solid border-gray-1200 md:pl-2' : '' }}">
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-location-pin class="w-4 h-4" />
                                </span>
                                <a href="{{ $user->mapUrl }}"
                                    target="_blank"
                                    class="transition-colors hover:text-primary-blue">
                                    {{ Str::headline(str()->limit($user->address('short'), 50)) }}
                                </a>
                            </li>
                        @endif
                        @if (!empty($user->profile->year_established))
                            <li class="text-mid-gray font-medium xl:text-sm md:text-xs text-sm tracking-[-0.096px] flex items-center gap-2 md:border-l border-solid border-gray-1200 md:px-2">
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-business-icon class="w-4 h-4" />
                                </span>
                                {{ Str::headline(__('In Business Since')) }} {{ $user->profile->year_established }}
                            </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
        @if ($user->membershipType->value !== App\Enums\MembershipType::Free->value)
            <div class="xl:max-w-[321px] lg:max-w-[200px] max-w-full w-full lg:mt-0 mt-4">
                <div class="md:mb-3">
                    <ul class="flex absolute top-0 right-0 gap-3 justify-center items-center md:static">
                        <li>
                            <x-frontend.includes.share-modal-button :user="$user"
                                url="{{ $user->permalink }}"
                                target="share-modal"
                                toggle="share-modal"
                                type="profile"
                                class="group md:border-0 border border-solid border-gray-1200 md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-8 h-8 md:h-10 md:px-3.5 pr-0.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
                                <x-icon-share-icon class="w-4 h-4" />
                                <span class="hidden md:block">{{ __('Share') }}</span>
                            </x-frontend.includes.share-modal-button>
                        </li>
                        <li>
                            <x-frontend.includes.add-favorite-button module="member"
                                :modelId="$user->uuid"
                                :isFavorite="$user->isFavorite()"
                                class="group md:border-0 border border-solid border-gray-1200 md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-8 h-8 md:h-10 md:px-3.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
                                <x-icon-save-icon class="w-4 h-4" />
                                <span class="hidden md:block">{{ __('Save') }}</span>
                            </x-frontend.includes.add-favorite-button>
                        </li>
                    </ul>
                </div>
                <div class="grid fixed right-0 bottom-0 left-0 z-10 grid-cols-2 gap-3 p-6 w-full bg-white border-t border-solid bottom-action md:block md:gap-0 md:bg-transparent md:w-auto md:static md:p-0 md:border-0 border-gray-1200 md:relative">
                    @if ($user->profile?->phone)
                        <a href="tel:{{ $user->profile->phone }}" class="mb-3 primary-btn">
                            <x-icon-phone-icon class="w-4 h-4" />
                            {{ __('Call') }}
                        </a>
                    @endif
                    @if (!empty($user->email))
                        <x-frontend.includes.contact-modal-button :user="$user" class="secondary-btn">
                            <x-icon-chat-icon-blue class="w-4 h-4" /> {{ __('Message us') }}
                        </x-frontend.includes.contact-modal-button>
                    @endif
                </div>
            </div>
        @endif
    </div>

    <div class="block md:hidden">
        @if (!empty($user->profile?->phone))
            <a href="tel:{{ $user->profile?->phone }}" class="mb-3 primary-btn">
                <x-icon-phone-icon /> {{ __('Calls') }}
            </a>
        @endif
        @if (!empty($user->email))
            <x-frontend.includes.contact-modal-button :user="$user" class="secondary-btn">
                <x-icon-chat-icon-blue class="w-4 h-4" /> {{ __('Message us') }}
            </x-frontend.includes.contact-modal-button>
        @endif
    </div>
    <!-- Service Area Section -->
    @if ($user->profile?->service_areas)
        <div class="block mt-6 md:hidden">
            <h4 class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px]">
                {{ __('Service area') }}
            </h4>
            <div x-data="{ expanded: false }">
                <ul class="flex flex-wrap gap-2 mt-3 w-full">
                    @foreach ($user->profile?->service_areas ?? [] as $area)
                        <li x-show="expanded || {{ $loop->index }} < 3"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform scale-95"
                            x-transition:enter-end="opacity-100 transform scale-100"
                            x-transition:leave="transition ease-in duration-150"
                            x-transition:leave-start="opacity-100 transform scale-100"
                            x-transition:leave-end="opacity-0 transform scale-95">
                            <a href="#" class="tags !border-transparent !h-7">{{ Str::headline($area) }}</a>
                        </li>
                    @endforeach
                </ul>

                @if (count($user->profile?->service_areas ?? []) > 3)
                    <a href="#"
                        @click.prevent="expanded = !expanded"
                        class="flex items-center text-sm font-medium tracking-[-0.096px] leading-5 gap-2.5 mt-5 text-primary-blue">
                        <span x-text="expanded ? '{{ __('Show less') }}' : '{{ __('Show all :count', ['count' => count($user->profile?->service_areas)]) }}'"></span>
                        <x-icon-down-arrow2 class="transition-transform duration-200" x-bind:class="{ 'rotate-180': expanded }" />
                    </a>
                @endif
            </div>
        </div>
    @endif
</div>
--}}
